#ifndef INCLUDE_CLASS_BACKLIGHT_H
#define INCLUDE_CLASS_BACKLIGHT_H
/* ----------------------------------------------------------------------------
 * class_backlight.h
 * prototypes and definitions for the class backlight.
 *
 * Copyright 2002-2006 Matthias Grimm
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 * ----------------------------------------------------------------------------*/

#include <pbbtaglist.h>

struct driver_backlight {
	char *name;
	int  (*get_brightness)();
	int  (*get_brightness_max)();
	void (*set_brightness)();
	void (*driver_exit)();
};

/* public prototypes class backlight*/
int backlight_init ();
int backlight_open (struct tagitem *taglist);
int backlight_close ();
int backlight_exit ();

/* private prototypes class backlight */
void backlight_query (struct tagitem *taglist);
void backlight_config (struct tagitem *taglist);
void backlight_handle_tags (int cfgure, struct tagitem *taglist);

#endif    /* INCLUDE_CLASS_BACKLIGHT_H */
