/* Verify that overloaded built-ins for vec_ld with float
   inputs produce the right code.  */

/* { dg-do compile } */
/* { dg-require-effective-target powerpc_altivec_ok } */
/* { dg-options "-maltivec -O2" } */

#include <altivec.h>

vector float
testld_ll_vf (long long ll1, vector float vf2)
{
  return vec_ld (ll1, &vf2);
}

vector float
testld_ll_f (long long ll1, float f2)
{
  return vec_ld (ll1, &f2);
}

vector float
testld_cst_vf (vector float vf2)
{
  return vec_ld (16, &vf2);
}

vector float
testld_cst_f (float f2)
{
  return vec_ld (16, &f2);
}

// lvx - generated by ll_vf and ll_f
// lxvd2x - generated by cst_vf and cst_f
/* { dg-final { scan-assembler-times {\mlvx\M|\mlxvd2x\M|\mlxv\M} 4 } } */

