#
# This include file is used by more than one test suite
# (currently rpl and binlog_encryption).
# Please check all dependent tests after modifying it
#

# See if "LOAD DATA LOCAL INFILE" is well replicated
# (LOAD DATA LOCAL INFILE is not written to the binlog
# the same way as LOAD DATA INFILE : Append_blocks are smaller).
# In MySQL 4.0 <4.0.12 there were 2 bugs with LOAD DATA LOCAL INFILE :
# - the loaded file was not written entirely to the master's binlog,
# only the first 4KB, 8KB or 16KB usually.
# - the loaded file's first line was not written entirely to the
# master's binlog (1st char was absent)
source include/master-slave.inc;

create table t1(a int);
let $1=10000;
disable_query_log;
set SQL_LOG_BIN=0;
while ($1)
{
 insert into t1 values(1);
 dec $1;
}
set SQL_LOG_BIN=1;
enable_query_log;
let $MYSQLD_DATADIR= `select @@datadir`;
--replace_result $MYSQLD_DATADIR MYSQLD_DATADIR
eval select * into outfile '$MYSQLD_DATADIR/rpl_loaddatalocal.select_outfile' from t1;
#This will generate a 20KB file, now test LOAD DATA LOCAL
truncate table t1;
--replace_result $MYSQLD_DATADIR MYSQLD_DATADIR
eval load data local infile '$MYSQLD_DATADIR/rpl_loaddatalocal.select_outfile' into table t1;
--remove_file $MYSQLD_DATADIR/rpl_loaddatalocal.select_outfile
sync_slave_with_master;
select a,count(*) from t1 group by a;
connection master;
drop table t1;
sync_slave_with_master;

# End of 4.1 tests

#
# Now let us test how well we replicate LOAD DATA LOCAL in situation when
# we met duplicates in tables to which we are adding rows.
# (It supposed that LOAD DATA LOCAL ignores such errors)
#
connection master;
create table t1(a int);
insert into t1 values (1), (2), (2), (3);
--replace_result $MYSQLD_DATADIR MYSQLD_DATADIR
eval select * into outfile '$MYSQLD_DATADIR/rpl_loaddatalocal.select_outfile' from t1;
drop table t1;
create table t1(a int primary key);
--replace_result $MYSQLD_DATADIR MYSQLD_DATADIR
eval load data local infile '$MYSQLD_DATADIR/rpl_loaddatalocal.select_outfile' into table t1;
--remove_file $MYSQLD_DATADIR/rpl_loaddatalocal.select_outfile
SELECT * FROM t1 ORDER BY a;
save_master_pos;
connection slave;
sync_with_master;
SELECT * FROM t1 ORDER BY a;
connection master;
drop table t1;
save_master_pos;
connection slave;
sync_with_master;


#
# Bug22504 load data infile sql statement in replication architecture get error
#
--echo ==== Bug22504 Initialize ====

--connection master

SET sql_mode='ignore_space';
CREATE TABLE t1(a int);
insert into t1 values (1), (2), (3), (4);
--replace_result $MYSQLD_DATADIR MYSQLD_DATADIR
eval select * into outfile '$MYSQLD_DATADIR/rpl_loaddatalocal.select_outfile' from t1;
truncate table t1;
--replace_result $MYSQLD_DATADIR MYSQLD_DATADIR
eval load data local infile '$MYSQLD_DATADIR/rpl_loaddatalocal.select_outfile' into table t1;
--remove_file $MYSQLD_DATADIR/rpl_loaddatalocal.select_outfile
SELECT * FROM t1 ORDER BY a;

sync_slave_with_master;
SELECT * FROM t1 ORDER BY a;

--echo ==== Clean up ====

connection master;
DROP TABLE t1;

sync_slave_with_master;

--echo
--echo Bug #43746:
--echo "return wrong query string when parse 'load data infile' sql statement"
--echo

connection master;
let $MYSQLD_DATADIR= `select @@datadir`;
SELECT @@SESSION.sql_mode INTO @old_mode;

SET sql_mode='ignore_space';

CREATE TABLE t1(a int);
INSERT INTO t1 VALUES (1), (2), (3), (4);

--replace_result $MYSQLD_DATADIR MYSQLD_DATADIR
eval SELECT * INTO OUTFILE '$MYSQLD_DATADIR/bug43746.sql' FROM t1;
TRUNCATE TABLE t1;

--replace_result $MYSQLD_DATADIR MYSQLD_DATADIR
eval LOAD DATA LOCAL INFILE '$MYSQLD_DATADIR/bug43746.sql' INTO TABLE t1;

--replace_result $MYSQLD_DATADIR MYSQLD_DATADIR
eval LOAD/* look mum, with comments in weird places! */DATA/* oh hai */LOCAL INFILE '$MYSQLD_DATADIR/bug43746.sql'/* we are */INTO/* from the internets */TABLE t1;

--replace_result $MYSQLD_DATADIR MYSQLD_DATADIR
eval LOAD DATA/*!10000 LOCAL */INFILE '$MYSQLD_DATADIR/bug43746.sql' INTO TABLE t1;

--replace_result $MYSQLD_DATADIR MYSQLD_DATADIR
eval LOAD DATA LOCAL INFILE '$MYSQLD_DATADIR/bug43746.sql' /*!10000 INTO */ TABLE t1;

--replace_result $MYSQLD_DATADIR MYSQLD_DATADIR
eval LOAD DATA LOCAL INFILE '$MYSQLD_DATADIR/bug43746.sql' /*!10000 INTO TABLE */ t1;

--replace_result $MYSQLD_DATADIR MYSQLD_DATADIR
eval LOAD DATA /*!10000 LOCAL INFILE '$MYSQLD_DATADIR/bug43746.sql' INTO TABLE */ t1;

--replace_result $MYSQLD_DATADIR MYSQLD_DATADIR
eval LOAD DATA/*!10000 LOCAL */INFILE '$MYSQLD_DATADIR/bug43746.sql'/*!10000 INTO*/TABLE t1;

--replace_result $MYSQLD_DATADIR MYSQLD_DATADIR
eval LOAD DATA/*!10000 LOCAL */INFILE '$MYSQLD_DATADIR/bug43746.sql'/* empty */INTO TABLE t1;

--replace_result $MYSQLD_DATADIR MYSQLD_DATADIR
eval LOAD DATA/*!10000 LOCAL */INFILE '$MYSQLD_DATADIR/bug43746.sql' INTO/* empty */TABLE t1;

--replace_result $MYSQLD_DATADIR MYSQLD_DATADIR
eval LOAD/*!999999 special comments that do not expand */DATA/*!999999 code from the future */LOCAL INFILE '$MYSQLD_DATADIR/bug43746.sql'/*!999999 have flux capacitor */INTO/*!999999 will travel */TABLE t1;

SET sql_mode='PIPES_AS_CONCAT,ANSI_QUOTES,NO_KEY_OPTIONS,NO_TABLE_OPTIONS,NO_FIELD_OPTIONS,STRICT_TRANS_TABLES,STRICT_ALL_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,TRADITIONAL,NO_AUTO_CREATE_USER';

--replace_result $MYSQLD_DATADIR MYSQLD_DATADIR
eval LOAD DATA LOCAL INFILE '$MYSQLD_DATADIR/bug43746.sql' INTO TABLE t1;

sync_slave_with_master;

--echo
--echo  Bug #59267:
--echo "LOAD DATA LOCAL INFILE not executed on slave with SBR"
--echo

connection master;

--replace_result $MYSQLD_DATADIR MYSQLD_DATADIR
eval SELECT * INTO OUTFILE '$MYSQLD_DATADIR/bug59267.sql' FROM t1;
TRUNCATE TABLE t1;

--replace_result $MYSQLD_DATADIR MYSQLD_DATADIR
eval LOAD DATA LOCAL INFILE '$MYSQLD_DATADIR/bug59267.sql' INTO TABLE t1;

SELECT 'Master', COUNT(*) FROM t1;

--sync_slave_with_master
SELECT 'Slave', COUNT(*) FROM t1;

# cleanup
connection master;

--remove_file $MYSQLD_DATADIR/bug43746.sql
--remove_file $MYSQLD_DATADIR/bug59267.sql

DROP TABLE t1;
SET SESSION sql_mode=@old_mode;

sync_slave_with_master;

connection master;

--echo
--echo Bug #60580/#11902767:
--echo "statement improperly replicated crashes slave sql thread"
--echo

connection master;
let $MYSQLD_DATADIR= `select @@datadir`;

CREATE TABLE t1(f1 INT, f2 INT);
CREATE TABLE t2(f1 INT, f2 TIMESTAMP);

INSERT INTO t2 VALUES(1, '2011-03-22 21:01:28');
INSERT INTO t2 VALUES(2, '2011-03-21 21:01:28');
INSERT INTO t2 VALUES(3, '2011-03-20 21:01:28');

CREATE TABLE t3 AS SELECT * FROM t2;

CREATE VIEW v1 AS SELECT * FROM t2
  WHERE f1 IN (SELECT f1 FROM t3 WHERE (t3.f2 IS NULL));

--replace_result $MYSQLD_DATADIR MYSQLD_DATADIR
eval SELECT 1 INTO OUTFILE '$MYSQLD_DATADIR/bug60580.csv' FROM DUAL;

--replace_result $MYSQLD_DATADIR MYSQLD_DATADIR
eval LOAD DATA LOCAL INFILE '$MYSQLD_DATADIR/bug60580.csv' INTO TABLE t1 (@f1) SET f2 = (SELECT f1 FROM v1 WHERE f1=@f1);

SELECT * FROM t1;

sleep 1;

sync_slave_with_master;

SELECT * FROM t1;

--remove_file $MYSQLD_DATADIR/bug60580.csv

connection master;

DROP VIEW v1;
DROP TABLE t1, t2, t3;

sync_slave_with_master;

connection master;
--source include/rpl_end.inc

--echo # End of 5.1 tests
