/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.jdbc;

import com.mysql.cj.api.jdbc.JdbcConnection;
import com.mysql.cj.api.jdbc.RowData;
import com.mysql.cj.core.Constants;
import com.mysql.cj.core.Messages;
import com.mysql.cj.core.MysqlType;
import com.mysql.cj.core.exceptions.AssertionFailedException;
import com.mysql.cj.core.exceptions.CJException;
import com.mysql.cj.core.profiler.ProfilerEventHandlerFactory;
import com.mysql.cj.core.profiler.ProfilerEventImpl;
import com.mysql.cj.core.result.Field;
import com.mysql.cj.core.util.StringUtils;
import com.mysql.cj.jdbc.ByteArrayRow;
import com.mysql.cj.jdbc.MysqlSQLXML;
import com.mysql.cj.jdbc.NClob;
import com.mysql.cj.jdbc.PreparedStatement;
import com.mysql.cj.jdbc.ResultSetImpl;
import com.mysql.cj.jdbc.ResultSetRow;
import com.mysql.cj.jdbc.StatementImpl;
import com.mysql.cj.jdbc.exceptions.NotUpdatable;
import com.mysql.cj.jdbc.exceptions.SQLError;
import com.mysql.cj.jdbc.exceptions.SQLExceptionsMapping;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class UpdatableResultSet
extends ResultSetImpl {
    static final byte[] STREAM_DATA_MARKER = StringUtils.getBytes("** STREAM DATA **");
    private String charEncoding;
    private byte[][] defaultColumnValue;
    private PreparedStatement deleter = null;
    private String deleteSQL = null;
    protected PreparedStatement inserter = null;
    private String insertSQL = null;
    private boolean isUpdatable = false;
    private String notUpdatableReason = null;
    private List<Integer> primaryKeyIndicies = null;
    private String qualifiedAndQuotedTableName;
    private String quotedIdChar = null;
    private PreparedStatement refresher;
    private String refreshSQL = null;
    private ResultSetRow savedCurrentRow;
    protected PreparedStatement updater = null;
    private String updateSQL = null;
    private boolean populateInserterWithDefaultValues = false;
    private boolean hasLongColumnInfo = false;
    private Map<String, Map<String, Map<String, Integer>>> databasesUsedToTablesUsed = null;

    protected UpdatableResultSet(String catalog, Field[] fields, RowData tuples, JdbcConnection conn, StatementImpl creatorStmt, boolean hasLongColumnInfo) throws SQLException {
        super(catalog, fields, tuples, conn, creatorStmt);
        this.checkUpdatability();
        this.populateInserterWithDefaultValues = this.connection.getPropertySet().getBooleanReadableProperty("populateInsertRowWithDefaultValues").getValue();
        this.hasLongColumnInfo = hasLongColumnInfo;
    }

    @Override
    public synchronized boolean absolute(int row) throws SQLException {
        try {
            return super.absolute(row);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void afterLast() throws SQLException {
        try {
            super.afterLast();
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void beforeFirst() throws SQLException {
        try {
            super.beforeFirst();
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void cancelRowUpdates() throws SQLException {
        try {
            this.checkClosed();
            if (this.doingUpdates) {
                this.doingUpdates = false;
                this.updater.clearParameters();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    protected synchronized void checkRowPos() throws SQLException {
        this.checkClosed();
        if (!this.onInsertRow) {
            super.checkRowPos();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkUpdatability() throws SQLException {
        try {
            if (this.fields == null) {
                return;
            }
            String singleTableName = null;
            String catalogName = null;
            int primaryKeyCount = 0;
            if (this.catalog == null || this.catalog.length() == 0) {
                this.catalog = this.fields[0].getDatabaseName();
                if (this.catalog == null || this.catalog.length() == 0) {
                    throw SQLError.createSQLException(Messages.getString("UpdatableResultSet.43"), "S1009", this.getExceptionInterceptor());
                }
            }
            if (this.fields.length > 0) {
                singleTableName = this.fields[0].getOriginalTableName();
                catalogName = this.fields[0].getDatabaseName();
                if (singleTableName == null) {
                    singleTableName = this.fields[0].getTableName();
                    catalogName = this.catalog;
                }
                if (singleTableName == null) {
                    this.isUpdatable = false;
                    this.notUpdatableReason = Messages.getString("NotUpdatableReason.3");
                    return;
                }
                if (this.fields[0].isPrimaryKey()) {
                    ++primaryKeyCount;
                }
                for (int i2 = 1; i2 < this.fields.length; ++i2) {
                    String otherTableName = this.fields[i2].getOriginalTableName();
                    String otherCatalogName = this.fields[i2].getDatabaseName();
                    if (otherTableName == null) {
                        otherTableName = this.fields[i2].getTableName();
                        otherCatalogName = this.catalog;
                    }
                    if (otherTableName == null) {
                        this.isUpdatable = false;
                        this.notUpdatableReason = Messages.getString("NotUpdatableReason.3");
                        return;
                    }
                    if (!otherTableName.equals(singleTableName)) {
                        this.isUpdatable = false;
                        this.notUpdatableReason = Messages.getString("NotUpdatableReason.0");
                        return;
                    }
                    if (catalogName == null || !otherCatalogName.equals(catalogName)) {
                        this.isUpdatable = false;
                        this.notUpdatableReason = Messages.getString("NotUpdatableReason.1");
                        return;
                    }
                    if (!this.fields[i2].isPrimaryKey()) continue;
                    ++primaryKeyCount;
                }
            } else {
                this.isUpdatable = false;
                this.notUpdatableReason = Messages.getString("NotUpdatableReason.3");
                return;
            }
            if (this.connection.getPropertySet().getBooleanReadableProperty("strictUpdates").getValue().booleanValue()) {
                DatabaseMetaData dbmd = this.connection.getMetaData();
                ResultSet rs = null;
                HashMap<String, String> primaryKeyNames = new HashMap<String, String>();
                try {
                    rs = dbmd.getPrimaryKeys(catalogName, null, singleTableName);
                    while (rs.next()) {
                        String keyName = rs.getString(4);
                        keyName = keyName.toUpperCase();
                        primaryKeyNames.put(keyName, keyName);
                    }
                }
                finally {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Exception ex) {
                            AssertionFailedException.shouldNotHappen(ex);
                        }
                        rs = null;
                    }
                }
                int existingPrimaryKeysCount = primaryKeyNames.size();
                if (existingPrimaryKeysCount == 0) {
                    this.isUpdatable = false;
                    this.notUpdatableReason = Messages.getString("NotUpdatableReason.5");
                    return;
                }
                for (int i3 = 0; i3 < this.fields.length; ++i3) {
                    String originalName;
                    String columnNameUC;
                    if (!this.fields[i3].isPrimaryKey() || primaryKeyNames.remove(columnNameUC = this.fields[i3].getName().toUpperCase()) != null || (originalName = this.fields[i3].getOriginalName()) == null || primaryKeyNames.remove(originalName.toUpperCase()) != null) continue;
                    this.isUpdatable = false;
                    this.notUpdatableReason = Messages.getString("NotUpdatableReason.6", new Object[]{originalName});
                    return;
                }
                this.isUpdatable = primaryKeyNames.isEmpty();
                if (!this.isUpdatable) {
                    this.notUpdatableReason = existingPrimaryKeysCount > 1 ? Messages.getString("NotUpdatableReason.7") : Messages.getString("NotUpdatableReason.4");
                    return;
                }
            }
            if (primaryKeyCount == 0) {
                this.isUpdatable = false;
                this.notUpdatableReason = Messages.getString("NotUpdatableReason.4");
                return;
            }
            this.isUpdatable = true;
            this.notUpdatableReason = null;
            return;
        }
        catch (SQLException sqlEx) {
            this.isUpdatable = false;
            this.notUpdatableReason = sqlEx.getMessage();
            return;
        }
    }

    @Override
    public synchronized void deleteRow() throws SQLException {
        try {
            this.checkClosed();
            if (!this.isUpdatable) {
                throw new NotUpdatable(this.notUpdatableReason);
            }
            if (this.onInsertRow) {
                throw SQLError.createSQLException(Messages.getString("UpdatableResultSet.1"), this.getExceptionInterceptor());
            }
            if (this.rowData.size() == 0) {
                throw SQLError.createSQLException(Messages.getString("UpdatableResultSet.2"), this.getExceptionInterceptor());
            }
            if (this.isBeforeFirst()) {
                throw SQLError.createSQLException(Messages.getString("UpdatableResultSet.3"), this.getExceptionInterceptor());
            }
            if (this.isAfterLast()) {
                throw SQLError.createSQLException(Messages.getString("UpdatableResultSet.4"), this.getExceptionInterceptor());
            }
            if (this.deleter == null) {
                if (this.deleteSQL == null) {
                    this.generateStatements();
                }
                this.deleter = (PreparedStatement)this.connection.clientPrepareStatement(this.deleteSQL);
            }
            this.deleter.clearParameters();
            int numKeys = this.primaryKeyIndicies.size();
            if (numKeys == 1) {
                int index = this.primaryKeyIndicies.get(0);
                this.setParamValue(this.deleter, 1, this.thisRow, index, this.fields[index].getMysqlType());
            } else {
                for (int i2 = 0; i2 < numKeys; ++i2) {
                    int index = this.primaryKeyIndicies.get(i2);
                    this.setParamValue(this.deleter, i2 + 1, this.thisRow, index, this.fields[index].getMysqlType());
                }
            }
            this.deleter.executeUpdate();
            this.rowData.removeRow(this.rowData.getCurrentRowNumber());
            this.previous();
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    private synchronized void setParamValue(PreparedStatement ps, int psIdx, ResultSetRow row, int rsIdx, MysqlType mysqlType) throws SQLException {
        byte[] val = row.getColumnValue(rsIdx);
        if (val == null) {
            ps.setNull(psIdx, MysqlType.NULL);
            return;
        }
        switch (mysqlType) {
            case NULL: {
                ps.setNull(psIdx, MysqlType.NULL);
                break;
            }
            case TINYINT: 
            case TINYINT_UNSIGNED: 
            case SMALLINT: 
            case SMALLINT_UNSIGNED: 
            case MEDIUMINT: 
            case MEDIUMINT_UNSIGNED: 
            case INT: 
            case INT_UNSIGNED: 
            case YEAR: {
                ps.setInt(psIdx, this.getInt(rsIdx + 1));
                break;
            }
            case BIGINT: {
                ps.setLong(psIdx, this.getLong(rsIdx + 1));
                break;
            }
            case BIGINT_UNSIGNED: {
                ps.setBigInteger(psIdx, this.getBigInteger(rsIdx + 1));
                break;
            }
            case CHAR: 
            case ENUM: 
            case SET: 
            case VARCHAR: 
            case JSON: 
            case TINYTEXT: 
            case TEXT: 
            case MEDIUMTEXT: 
            case LONGTEXT: 
            case DECIMAL: 
            case DECIMAL_UNSIGNED: {
                ps.setString(psIdx, this.getString(rsIdx + 1));
                break;
            }
            case DATE: {
                ps.setDate(psIdx, this.getDate(rsIdx + 1));
                break;
            }
            case TIMESTAMP: 
            case DATETIME: {
                ps.setTimestamp(psIdx, this.getTimestamp(rsIdx + 1));
                break;
            }
            case TIME: {
                ps.setTime(psIdx, this.getTime(rsIdx + 1));
                break;
            }
            case DOUBLE: 
            case DOUBLE_UNSIGNED: 
            case FLOAT: 
            case FLOAT_UNSIGNED: 
            case BOOLEAN: {
                ps.setBytesNoEscapeNoQuotes(psIdx, val);
                break;
            }
            default: {
                ps.setBytes(psIdx, val);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void extractDefaultValues() throws SQLException {
        DatabaseMetaData dbmd = this.connection.getMetaData();
        this.defaultColumnValue = new byte[this.fields.length][];
        ResultSet columnsResultSet = null;
        for (Map.Entry<String, Map<String, Map<String, Integer>>> dbEntry : this.databasesUsedToTablesUsed.entrySet()) {
            for (Map.Entry<String, Map<String, Integer>> tableEntry : dbEntry.getValue().entrySet()) {
                String tableName = tableEntry.getKey();
                Map<String, Integer> columnNamesToIndices = tableEntry.getValue();
                try {
                    columnsResultSet = dbmd.getColumns(this.catalog, null, tableName, "%");
                    while (columnsResultSet.next()) {
                        String columnName = columnsResultSet.getString("COLUMN_NAME");
                        byte[] defaultValue = columnsResultSet.getBytes("COLUMN_DEF");
                        if (!columnNamesToIndices.containsKey(columnName)) continue;
                        int localColumnIndex = columnNamesToIndices.get(columnName);
                        this.defaultColumnValue[localColumnIndex] = defaultValue;
                    }
                }
                finally {
                    if (columnsResultSet == null) continue;
                    columnsResultSet.close();
                    columnsResultSet = null;
                }
            }
        }
    }

    @Override
    public synchronized boolean first() throws SQLException {
        try {
            return super.first();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    protected synchronized void generateStatements() throws SQLException {
        try {
            if (!this.isUpdatable) {
                this.doingUpdates = false;
                this.onInsertRow = false;
                throw new NotUpdatable(this.notUpdatableReason);
            }
            String quotedId = this.getQuotedIdChar();
            TreeMap<String, String> tableNamesSoFar = null;
            if (this.connection.lowerCaseTableNames()) {
                tableNamesSoFar = new TreeMap(String.CASE_INSENSITIVE_ORDER);
                this.databasesUsedToTablesUsed = new TreeMap<String, Map<String, Map<String, Integer>>>(String.CASE_INSENSITIVE_ORDER);
            } else {
                tableNamesSoFar = new TreeMap<String, String>();
                this.databasesUsedToTablesUsed = new TreeMap<String, Map<String, Map<String, Integer>>>();
            }
            this.primaryKeyIndicies = new ArrayList<Integer>();
            StringBuilder fieldValues = new StringBuilder();
            StringBuilder keyValues = new StringBuilder();
            StringBuilder columnNames = new StringBuilder();
            StringBuilder insertPlaceHolders = new StringBuilder();
            StringBuilder allTablesBuf = new StringBuilder();
            HashMap<Integer, String> columnIndicesToTable = new HashMap<Integer, String>();
            boolean firstTime = true;
            boolean keysFirstTime = true;
            for (int i2 = 0; i2 < this.fields.length; ++i2) {
                StringBuilder tableNameBuffer = new StringBuilder();
                Map<String, Integer> updColumnNameToIndex = null;
                if (this.fields[i2].getOriginalTableName() != null) {
                    String databaseName = this.fields[i2].getDatabaseName();
                    if (databaseName != null && databaseName.length() > 0) {
                        tableNameBuffer.append(quotedId);
                        tableNameBuffer.append(databaseName);
                        tableNameBuffer.append(quotedId);
                        tableNameBuffer.append('.');
                    }
                    String tableOnlyName = this.fields[i2].getOriginalTableName();
                    tableNameBuffer.append(quotedId);
                    tableNameBuffer.append(tableOnlyName);
                    tableNameBuffer.append(quotedId);
                    String fqTableName = tableNameBuffer.toString();
                    if (!tableNamesSoFar.containsKey(fqTableName)) {
                        if (!tableNamesSoFar.isEmpty()) {
                            allTablesBuf.append(',');
                        }
                        allTablesBuf.append(fqTableName);
                        tableNamesSoFar.put(fqTableName, fqTableName);
                    }
                    columnIndicesToTable.put(i2, fqTableName);
                    updColumnNameToIndex = this.getColumnsToIndexMapForTableAndDB(databaseName, tableOnlyName);
                } else {
                    String tableOnlyName = this.fields[i2].getTableName();
                    if (tableOnlyName != null) {
                        tableNameBuffer.append(quotedId);
                        tableNameBuffer.append(tableOnlyName);
                        tableNameBuffer.append(quotedId);
                        String fqTableName = tableNameBuffer.toString();
                        if (!tableNamesSoFar.containsKey(fqTableName)) {
                            if (!tableNamesSoFar.isEmpty()) {
                                allTablesBuf.append(',');
                            }
                            allTablesBuf.append(fqTableName);
                            tableNamesSoFar.put(fqTableName, fqTableName);
                        }
                        columnIndicesToTable.put(i2, fqTableName);
                        updColumnNameToIndex = this.getColumnsToIndexMapForTableAndDB(this.catalog, tableOnlyName);
                    }
                }
                String originalColumnName = this.fields[i2].getOriginalName();
                String columnName = null;
                columnName = this.hasLongColumnInfo && originalColumnName != null && originalColumnName.length() > 0 ? originalColumnName : this.fields[i2].getName();
                if (updColumnNameToIndex != null && columnName != null) {
                    updColumnNameToIndex.put(columnName, i2);
                }
                String originalTableName = this.fields[i2].getOriginalTableName();
                String tableName = null;
                tableName = this.hasLongColumnInfo && originalTableName != null && originalTableName.length() > 0 ? originalTableName : this.fields[i2].getTableName();
                StringBuilder fqcnBuf = new StringBuilder();
                String databaseName = this.fields[i2].getDatabaseName();
                if (databaseName != null && databaseName.length() > 0) {
                    fqcnBuf.append(quotedId);
                    fqcnBuf.append(databaseName);
                    fqcnBuf.append(quotedId);
                    fqcnBuf.append('.');
                }
                fqcnBuf.append(quotedId);
                fqcnBuf.append(tableName);
                fqcnBuf.append(quotedId);
                fqcnBuf.append('.');
                fqcnBuf.append(quotedId);
                fqcnBuf.append(columnName);
                fqcnBuf.append(quotedId);
                String qualifiedColumnName = fqcnBuf.toString();
                if (this.fields[i2].isPrimaryKey()) {
                    this.primaryKeyIndicies.add(i2);
                    if (!keysFirstTime) {
                        keyValues.append(" AND ");
                    } else {
                        keysFirstTime = false;
                    }
                    keyValues.append(qualifiedColumnName);
                    keyValues.append("<=>");
                    keyValues.append("?");
                }
                if (firstTime) {
                    firstTime = false;
                    fieldValues.append("SET ");
                } else {
                    fieldValues.append(",");
                    columnNames.append(",");
                    insertPlaceHolders.append(",");
                }
                insertPlaceHolders.append("?");
                columnNames.append(qualifiedColumnName);
                fieldValues.append(qualifiedColumnName);
                fieldValues.append("=?");
            }
            this.qualifiedAndQuotedTableName = allTablesBuf.toString();
            this.updateSQL = "UPDATE " + this.qualifiedAndQuotedTableName + " " + fieldValues.toString() + " WHERE " + keyValues.toString();
            this.insertSQL = "INSERT INTO " + this.qualifiedAndQuotedTableName + " (" + columnNames.toString() + ") VALUES (" + insertPlaceHolders.toString() + ")";
            this.refreshSQL = "SELECT " + columnNames.toString() + " FROM " + this.qualifiedAndQuotedTableName + " WHERE " + keyValues.toString();
            this.deleteSQL = "DELETE FROM " + this.qualifiedAndQuotedTableName + " WHERE " + keyValues.toString();
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    private Map<String, Integer> getColumnsToIndexMapForTableAndDB(String databaseName, String tableName) {
        Map<String, Integer> nameToIndex;
        Map<String, Map<String, Integer>> tablesUsedToColumnsMap = this.databasesUsedToTablesUsed.get(databaseName);
        if (tablesUsedToColumnsMap == null) {
            tablesUsedToColumnsMap = this.connection.lowerCaseTableNames() ? new TreeMap<String, Map<String, Integer>>(String.CASE_INSENSITIVE_ORDER) : new TreeMap<String, Map<String, Integer>>();
            this.databasesUsedToTablesUsed.put(databaseName, tablesUsedToColumnsMap);
        }
        if ((nameToIndex = tablesUsedToColumnsMap.get(tableName)) == null) {
            nameToIndex = new HashMap<String, Integer>();
            tablesUsedToColumnsMap.put(tableName, nameToIndex);
        }
        return nameToIndex;
    }

    @Override
    public int getConcurrency() throws SQLException {
        try {
            return this.isUpdatable ? 1008 : 1007;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    private synchronized String getQuotedIdChar() throws SQLException {
        if (this.quotedIdChar == null) {
            DatabaseMetaData dbmd = this.connection.getMetaData();
            this.quotedIdChar = dbmd.getIdentifierQuoteString();
        }
        return this.quotedIdChar;
    }

    @Override
    public synchronized void insertRow() throws SQLException {
        try {
            this.checkClosed();
            if (!this.onInsertRow) {
                throw SQLError.createSQLException(Messages.getString("UpdatableResultSet.7"), this.getExceptionInterceptor());
            }
            this.inserter.executeUpdate();
            long autoIncrementId = this.inserter.getLastInsertID();
            int numFields = this.fields.length;
            byte[][] newRow = new byte[numFields][];
            for (int i2 = 0; i2 < numFields; ++i2) {
                newRow[i2] = (byte[])(this.inserter.isNull(i2) ? null : this.inserter.getBytesRepresentation(i2));
                if (!this.fields[i2].isAutoIncrement() || autoIncrementId <= 0L) continue;
                newRow[i2] = StringUtils.getBytes(String.valueOf(autoIncrementId));
                this.inserter.setBytesNoEscapeNoQuotes(i2 + 1, newRow[i2]);
            }
            ByteArrayRow resultSetRow = new ByteArrayRow(newRow, this.getExceptionInterceptor());
            this.refreshRow(this.inserter, resultSetRow);
            this.rowData.addRow(resultSetRow);
            this.resetInserter();
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized boolean isAfterLast() throws SQLException {
        try {
            return super.isAfterLast();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized boolean isBeforeFirst() throws SQLException {
        try {
            return super.isBeforeFirst();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized boolean isFirst() throws SQLException {
        try {
            return super.isFirst();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized boolean isLast() throws SQLException {
        try {
            return super.isLast();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    boolean isUpdatable() {
        return this.isUpdatable;
    }

    @Override
    public synchronized boolean last() throws SQLException {
        try {
            return super.last();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void moveToCurrentRow() throws SQLException {
        try {
            this.checkClosed();
            if (!this.isUpdatable) {
                throw new NotUpdatable(this.notUpdatableReason);
            }
            if (this.onInsertRow) {
                this.onInsertRow = false;
                this.thisRow = this.savedCurrentRow;
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void moveToInsertRow() throws SQLException {
        try {
            this.checkClosed();
            if (!this.isUpdatable) {
                throw new NotUpdatable(this.notUpdatableReason);
            }
            if (this.inserter == null) {
                if (this.insertSQL == null) {
                    this.generateStatements();
                }
                this.inserter = (PreparedStatement)this.connection.clientPrepareStatement(this.insertSQL);
                if (this.populateInserterWithDefaultValues) {
                    this.extractDefaultValues();
                }
                this.resetInserter();
            } else {
                this.resetInserter();
            }
            int numFields = this.fields.length;
            this.onInsertRow = true;
            this.doingUpdates = false;
            this.savedCurrentRow = this.thisRow;
            Object newRowData = new byte[numFields][];
            this.thisRow = new ByteArrayRow((byte[][])newRowData, this.getExceptionInterceptor());
            this.thisRow.setMetadata(this.fields);
            for (int i2 = 0; i2 < numFields; ++i2) {
                if (!this.populateInserterWithDefaultValues) {
                    this.inserter.setBytesNoEscapeNoQuotes(i2 + 1, StringUtils.getBytes("DEFAULT"));
                    newRowData = null;
                    continue;
                }
                if (this.defaultColumnValue[i2] != null) {
                    Field f2 = this.fields[i2];
                    switch (f2.getMysqlTypeId()) {
                        case 7: 
                        case 10: 
                        case 11: 
                        case 12: {
                            if (this.defaultColumnValue[i2].length > 7 && this.defaultColumnValue[i2][0] == 67 && this.defaultColumnValue[i2][1] == 85 && this.defaultColumnValue[i2][2] == 82 && this.defaultColumnValue[i2][3] == 82 && this.defaultColumnValue[i2][4] == 69 && this.defaultColumnValue[i2][5] == 78 && this.defaultColumnValue[i2][6] == 84 && this.defaultColumnValue[i2][7] == 95) {
                                this.inserter.setBytesNoEscapeNoQuotes(i2 + 1, this.defaultColumnValue[i2]);
                                break;
                            }
                            this.inserter.setBytes(i2 + 1, this.defaultColumnValue[i2], false, false);
                            break;
                        }
                        default: {
                            this.inserter.setBytes(i2 + 1, this.defaultColumnValue[i2], false, false);
                        }
                    }
                    byte[] defaultValueCopy = new byte[this.defaultColumnValue[i2].length];
                    System.arraycopy(this.defaultColumnValue[i2], 0, defaultValueCopy, 0, defaultValueCopy.length);
                    newRowData[i2] = defaultValueCopy;
                    continue;
                }
                this.inserter.setNull(i2 + 1, MysqlType.NULL);
                newRowData[i2] = null;
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized boolean next() throws SQLException {
        try {
            return super.next();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized boolean prev() throws SQLException {
        return super.prev();
    }

    @Override
    public synchronized boolean previous() throws SQLException {
        try {
            return super.previous();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void realClose(boolean calledExplicitly) throws SQLException {
        try {
            if (this.isClosed) {
                return;
            }
            SQLException sqlEx = null;
            if (this.useUsageAdvisor && this.deleter == null && this.inserter == null && this.refresher == null && this.updater == null) {
                this.eventSink = ProfilerEventHandlerFactory.getInstance(this.connection);
                String message = Messages.getString("UpdatableResultSet.34");
                this.eventSink.consumeEvent(new ProfilerEventImpl(0, "", this.owningStatement == null ? "N/A" : this.owningStatement.currentCatalog, this.connectionId, this.owningStatement == null ? -1 : this.owningStatement.getId(), this.resultId, System.currentTimeMillis(), 0L, Constants.MILLIS_I18N, null, this.pointOfOrigin, message));
            }
            try {
                if (this.deleter != null) {
                    this.deleter.close();
                }
            }
            catch (SQLException ex) {
                sqlEx = ex;
            }
            try {
                if (this.inserter != null) {
                    this.inserter.close();
                }
            }
            catch (SQLException ex) {
                sqlEx = ex;
            }
            try {
                if (this.refresher != null) {
                    this.refresher.close();
                }
            }
            catch (SQLException ex) {
                sqlEx = ex;
            }
            try {
                if (this.updater != null) {
                    this.updater.close();
                }
            }
            catch (SQLException ex) {
                sqlEx = ex;
            }
            super.realClose(calledExplicitly);
            if (sqlEx != null) {
                throw sqlEx;
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void refreshRow() throws SQLException {
        try {
            this.checkClosed();
            if (!this.isUpdatable) {
                throw SQLError.notUpdatable();
            }
            if (this.onInsertRow) {
                throw SQLError.createSQLException(Messages.getString("UpdatableResultSet.8"), this.getExceptionInterceptor());
            }
            if (this.rowData.size() == 0) {
                throw SQLError.createSQLException(Messages.getString("UpdatableResultSet.9"), this.getExceptionInterceptor());
            }
            if (this.isBeforeFirst()) {
                throw SQLError.createSQLException(Messages.getString("UpdatableResultSet.10"), this.getExceptionInterceptor());
            }
            if (this.isAfterLast()) {
                throw SQLError.createSQLException(Messages.getString("UpdatableResultSet.11"), this.getExceptionInterceptor());
            }
            this.refreshRow(this.updater, this.thisRow);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void refreshRow(PreparedStatement updateInsertStmt, ResultSetRow rowToRefresh) throws SQLException {
        block22: {
            if (this.refresher == null) {
                if (this.refreshSQL == null) {
                    this.generateStatements();
                }
                this.refresher = (PreparedStatement)this.connection.clientPrepareStatement(this.refreshSQL);
            }
            this.refresher.clearParameters();
            int numKeys = this.primaryKeyIndicies.size();
            if (numKeys == 1) {
                byte[] dataFrom = null;
                int index = this.primaryKeyIndicies.get(0);
                if (!this.doingUpdates && !this.onInsertRow) {
                    dataFrom = rowToRefresh.getColumnValue(index);
                } else {
                    dataFrom = updateInsertStmt.getBytesRepresentation(index);
                    dataFrom = updateInsertStmt.isNull(index) || dataFrom.length == 0 ? rowToRefresh.getColumnValue(index) : this.stripBinaryPrefix(dataFrom);
                }
                if (this.fields[index].getValueNeedsQuoting()) {
                    this.refresher.setBytesNoEscape(1, dataFrom);
                } else {
                    this.refresher.setBytesNoEscapeNoQuotes(1, dataFrom);
                }
            } else {
                for (int i2 = 0; i2 < numKeys; ++i2) {
                    byte[] dataFrom = null;
                    int index = this.primaryKeyIndicies.get(i2);
                    if (!this.doingUpdates && !this.onInsertRow) {
                        dataFrom = rowToRefresh.getColumnValue(index);
                    } else {
                        dataFrom = updateInsertStmt.getBytesRepresentation(index);
                        dataFrom = updateInsertStmt.isNull(index) || dataFrom.length == 0 ? rowToRefresh.getColumnValue(index) : this.stripBinaryPrefix(dataFrom);
                    }
                    this.refresher.setBytesNoEscape(i2 + 1, dataFrom);
                }
            }
            ResultSet rs = null;
            try {
                rs = this.refresher.executeQuery();
                int numCols = rs.getMetaData().getColumnCount();
                if (rs.next()) {
                    for (int i3 = 0; i3 < numCols; ++i3) {
                        byte[] val = rs.getBytes(i3 + 1);
                        if (val == null || rs.wasNull()) {
                            rowToRefresh.setColumnValue(i3, null);
                            continue;
                        }
                        rowToRefresh.setColumnValue(i3, rs.getBytes(i3 + 1));
                    }
                    break block22;
                }
                throw SQLError.createSQLException(Messages.getString("UpdatableResultSet.12"), "S1000", this.getExceptionInterceptor());
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
    }

    @Override
    public synchronized boolean relative(int rows) throws SQLException {
        try {
            return super.relative(rows);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    private void resetInserter() throws SQLException {
        this.inserter.clearParameters();
        for (int i2 = 0; i2 < this.fields.length; ++i2) {
            this.inserter.setNull(i2 + 1, 0);
        }
    }

    @Override
    public synchronized boolean rowDeleted() throws SQLException {
        try {
            throw SQLError.createSQLFeatureNotSupportedException();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized boolean rowInserted() throws SQLException {
        try {
            throw SQLError.createSQLFeatureNotSupportedException();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized boolean rowUpdated() throws SQLException {
        try {
            throw SQLError.createSQLFeatureNotSupportedException();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    protected void setResultSetConcurrency(int concurrencyFlag) {
        super.setResultSetConcurrency(concurrencyFlag);
    }

    private byte[] stripBinaryPrefix(byte[] dataFrom) {
        return StringUtils.stripEnclosure(dataFrom, "_binary'", "'");
    }

    protected synchronized void syncUpdate() throws SQLException {
        if (this.updater == null) {
            if (this.updateSQL == null) {
                this.generateStatements();
            }
            this.updater = (PreparedStatement)this.connection.clientPrepareStatement(this.updateSQL);
        }
        int numFields = this.fields.length;
        this.updater.clearParameters();
        for (int i2 = 0; i2 < numFields; ++i2) {
            if (this.thisRow.getColumnValue(i2) != null) {
                if (this.fields[i2].getValueNeedsQuoting()) {
                    this.updater.setBytes(i2 + 1, this.thisRow.getColumnValue(i2), this.fields[i2].isBinary(), false);
                    continue;
                }
                this.updater.setBytesNoEscapeNoQuotes(i2 + 1, this.thisRow.getColumnValue(i2));
                continue;
            }
            this.updater.setNull(i2 + 1, 0);
        }
        int numKeys = this.primaryKeyIndicies.size();
        if (numKeys == 1) {
            int index = this.primaryKeyIndicies.get(0);
            this.setParamValue(this.updater, numFields + 1, this.thisRow, index, this.fields[index].getMysqlType());
        } else {
            for (int i3 = 0; i3 < numKeys; ++i3) {
                int idx = this.primaryKeyIndicies.get(i3);
                this.setParamValue(this.updater, numFields + i3 + 1, this.thisRow, idx, this.fields[idx].getMysqlType());
            }
        }
    }

    @Override
    public synchronized void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        try {
            if (!this.onInsertRow) {
                if (!this.doingUpdates) {
                    this.doingUpdates = true;
                    this.syncUpdate();
                }
                this.updater.setAsciiStream(columnIndex, x, length);
            } else {
                this.inserter.setAsciiStream(columnIndex, x, length);
                this.thisRow.setColumnValue(columnIndex - 1, STREAM_DATA_MARKER);
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        try {
            this.updateAsciiStream(this.findColumn(columnName), x, length);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        try {
            if (!this.onInsertRow) {
                if (!this.doingUpdates) {
                    this.doingUpdates = true;
                    this.syncUpdate();
                }
                this.updater.setBigDecimal(columnIndex, x);
            } else {
                this.inserter.setBigDecimal(columnIndex, x);
                if (x == null) {
                    this.thisRow.setColumnValue(columnIndex - 1, null);
                } else {
                    this.thisRow.setColumnValue(columnIndex - 1, StringUtils.getBytes(x.toString()));
                }
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        try {
            this.updateBigDecimal(this.findColumn(columnName), x);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        try {
            if (!this.onInsertRow) {
                if (!this.doingUpdates) {
                    this.doingUpdates = true;
                    this.syncUpdate();
                }
                this.updater.setBinaryStream(columnIndex, x, length);
            } else {
                this.inserter.setBinaryStream(columnIndex, x, length);
                if (x == null) {
                    this.thisRow.setColumnValue(columnIndex - 1, null);
                } else {
                    this.thisRow.setColumnValue(columnIndex - 1, STREAM_DATA_MARKER);
                }
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        try {
            this.updateBinaryStream(this.findColumn(columnName), x, length);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void updateBlob(int columnIndex, Blob blob) throws SQLException {
        try {
            if (!this.onInsertRow) {
                if (!this.doingUpdates) {
                    this.doingUpdates = true;
                    this.syncUpdate();
                }
                this.updater.setBlob(columnIndex, blob);
            } else {
                this.inserter.setBlob(columnIndex, blob);
                if (blob == null) {
                    this.thisRow.setColumnValue(columnIndex - 1, null);
                } else {
                    this.thisRow.setColumnValue(columnIndex - 1, STREAM_DATA_MARKER);
                }
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void updateBlob(String columnName, Blob blob) throws SQLException {
        try {
            this.updateBlob(this.findColumn(columnName), blob);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void updateBoolean(int columnIndex, boolean x) throws SQLException {
        try {
            if (!this.onInsertRow) {
                if (!this.doingUpdates) {
                    this.doingUpdates = true;
                    this.syncUpdate();
                }
                this.updater.setBoolean(columnIndex, x);
            } else {
                this.inserter.setBoolean(columnIndex, x);
                this.thisRow.setColumnValue(columnIndex - 1, this.inserter.getBytesRepresentation(columnIndex - 1));
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void updateBoolean(String columnName, boolean x) throws SQLException {
        try {
            this.updateBoolean(this.findColumn(columnName), x);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void updateByte(int columnIndex, byte x) throws SQLException {
        try {
            if (!this.onInsertRow) {
                if (!this.doingUpdates) {
                    this.doingUpdates = true;
                    this.syncUpdate();
                }
                this.updater.setByte(columnIndex, x);
            } else {
                this.inserter.setByte(columnIndex, x);
                this.thisRow.setColumnValue(columnIndex - 1, this.inserter.getBytesRepresentation(columnIndex - 1));
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void updateByte(String columnName, byte x) throws SQLException {
        try {
            this.updateByte(this.findColumn(columnName), x);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void updateBytes(int columnIndex, byte[] x) throws SQLException {
        try {
            if (!this.onInsertRow) {
                if (!this.doingUpdates) {
                    this.doingUpdates = true;
                    this.syncUpdate();
                }
                this.updater.setBytes(columnIndex, x);
            } else {
                this.inserter.setBytes(columnIndex, x);
                this.thisRow.setColumnValue(columnIndex - 1, x);
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void updateBytes(String columnName, byte[] x) throws SQLException {
        try {
            this.updateBytes(this.findColumn(columnName), x);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        try {
            if (!this.onInsertRow) {
                if (!this.doingUpdates) {
                    this.doingUpdates = true;
                    this.syncUpdate();
                }
                this.updater.setCharacterStream(columnIndex, x, length);
            } else {
                this.inserter.setCharacterStream(columnIndex, x, length);
                if (x == null) {
                    this.thisRow.setColumnValue(columnIndex - 1, null);
                } else {
                    this.thisRow.setColumnValue(columnIndex - 1, STREAM_DATA_MARKER);
                }
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        try {
            this.updateCharacterStream(this.findColumn(columnName), reader, length);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void updateClob(int columnIndex, Clob clob) throws SQLException {
        try {
            if (clob == null) {
                this.updateNull(columnIndex);
            } else {
                this.updateCharacterStream(columnIndex, clob.getCharacterStream(), (int)clob.length());
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void updateDate(int columnIndex, Date x) throws SQLException {
        try {
            if (!this.onInsertRow) {
                if (!this.doingUpdates) {
                    this.doingUpdates = true;
                    this.syncUpdate();
                }
                this.updater.setDate(columnIndex, x);
            } else {
                this.inserter.setDate(columnIndex, x);
                this.thisRow.setColumnValue(columnIndex - 1, this.inserter.getBytesRepresentation(columnIndex - 1));
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void updateDate(String columnName, Date x) throws SQLException {
        try {
            this.updateDate(this.findColumn(columnName), x);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void updateDouble(int columnIndex, double x) throws SQLException {
        try {
            if (!this.onInsertRow) {
                if (!this.doingUpdates) {
                    this.doingUpdates = true;
                    this.syncUpdate();
                }
                this.updater.setDouble(columnIndex, x);
            } else {
                this.inserter.setDouble(columnIndex, x);
                this.thisRow.setColumnValue(columnIndex - 1, this.inserter.getBytesRepresentation(columnIndex - 1));
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void updateDouble(String columnName, double x) throws SQLException {
        try {
            this.updateDouble(this.findColumn(columnName), x);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void updateFloat(int columnIndex, float x) throws SQLException {
        try {
            if (!this.onInsertRow) {
                if (!this.doingUpdates) {
                    this.doingUpdates = true;
                    this.syncUpdate();
                }
                this.updater.setFloat(columnIndex, x);
            } else {
                this.inserter.setFloat(columnIndex, x);
                this.thisRow.setColumnValue(columnIndex - 1, this.inserter.getBytesRepresentation(columnIndex - 1));
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void updateFloat(String columnName, float x) throws SQLException {
        try {
            this.updateFloat(this.findColumn(columnName), x);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void updateInt(int columnIndex, int x) throws SQLException {
        try {
            if (!this.onInsertRow) {
                if (!this.doingUpdates) {
                    this.doingUpdates = true;
                    this.syncUpdate();
                }
                this.updater.setInt(columnIndex, x);
            } else {
                this.inserter.setInt(columnIndex, x);
                this.thisRow.setColumnValue(columnIndex - 1, this.inserter.getBytesRepresentation(columnIndex - 1));
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void updateInt(String columnName, int x) throws SQLException {
        try {
            this.updateInt(this.findColumn(columnName), x);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void updateLong(int columnIndex, long x) throws SQLException {
        try {
            if (!this.onInsertRow) {
                if (!this.doingUpdates) {
                    this.doingUpdates = true;
                    this.syncUpdate();
                }
                this.updater.setLong(columnIndex, x);
            } else {
                this.inserter.setLong(columnIndex, x);
                this.thisRow.setColumnValue(columnIndex - 1, this.inserter.getBytesRepresentation(columnIndex - 1));
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void updateLong(String columnName, long x) throws SQLException {
        try {
            this.updateLong(this.findColumn(columnName), x);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void updateNull(int columnIndex) throws SQLException {
        try {
            if (!this.onInsertRow) {
                if (!this.doingUpdates) {
                    this.doingUpdates = true;
                    this.syncUpdate();
                }
                this.updater.setNull(columnIndex, 0);
            } else {
                this.inserter.setNull(columnIndex, 0);
                this.thisRow.setColumnValue(columnIndex - 1, null);
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void updateNull(String columnName) throws SQLException {
        try {
            this.updateNull(this.findColumn(columnName));
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void updateObject(int columnIndex, Object x) throws SQLException {
        try {
            this.updateObjectInternal(columnIndex, x, null, 0);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        try {
            this.updateObjectInternal(columnIndex, x, null, scale);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    protected synchronized void updateObjectInternal(int columnIndex, Object x, Integer targetType, int scaleOrLength) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            if (targetType == null) {
                this.updater.setObject(columnIndex, x);
            } else {
                this.updater.setObject(columnIndex, x, targetType);
            }
        } else {
            if (targetType == null) {
                this.inserter.setObject(columnIndex, x);
            } else {
                this.inserter.setObject(columnIndex, x, targetType);
            }
            this.thisRow.setColumnValue(columnIndex - 1, this.inserter.getBytesRepresentation(columnIndex - 1));
        }
    }

    @Override
    public synchronized void updateObject(String columnName, Object x) throws SQLException {
        try {
            this.updateObject(this.findColumn(columnName), x);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void updateObject(String columnName, Object x, int scale) throws SQLException {
        try {
            this.updateObject(this.findColumn(columnName), x);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void updateObject(int columnIndex, Object x, SQLType targetSqlType) throws SQLException {
        try {
            this.updateObjectInternal(columnIndex, x, targetSqlType.getVendorTypeNumber(), 0);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void updateObject(int columnIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        try {
            this.updateObjectInternal(columnIndex, x, targetSqlType.getVendorTypeNumber(), scaleOrLength);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void updateObject(String columnLabel, Object x, SQLType targetSqlType) throws SQLException {
        try {
            this.updateObjectInternal(this.findColumn(columnLabel), x, targetSqlType.getVendorTypeNumber(), 0);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void updateObject(String columnLabel, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        try {
            this.updateObjectInternal(this.findColumn(columnLabel), x, targetSqlType.getVendorTypeNumber(), scaleOrLength);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void updateRow() throws SQLException {
        try {
            if (!this.isUpdatable) {
                throw new NotUpdatable(this.notUpdatableReason);
            }
            if (this.doingUpdates) {
                this.updater.executeUpdate();
                this.refreshRow();
                this.doingUpdates = false;
            } else if (this.onInsertRow) {
                throw SQLError.createSQLException(Messages.getString("UpdatableResultSet.44"), this.getExceptionInterceptor());
            }
            this.syncUpdate();
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void updateShort(int columnIndex, short x) throws SQLException {
        try {
            if (!this.onInsertRow) {
                if (!this.doingUpdates) {
                    this.doingUpdates = true;
                    this.syncUpdate();
                }
                this.updater.setShort(columnIndex, x);
            } else {
                this.inserter.setShort(columnIndex, x);
                this.thisRow.setColumnValue(columnIndex - 1, this.inserter.getBytesRepresentation(columnIndex - 1));
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void updateShort(String columnName, short x) throws SQLException {
        try {
            this.updateShort(this.findColumn(columnName), x);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void updateString(int columnIndex, String x) throws SQLException {
        try {
            this.checkClosed();
            if (!this.onInsertRow) {
                if (!this.doingUpdates) {
                    this.doingUpdates = true;
                    this.syncUpdate();
                }
                this.updater.setString(columnIndex, x);
            } else {
                this.inserter.setString(columnIndex, x);
                if (x == null) {
                    this.thisRow.setColumnValue(columnIndex - 1, null);
                } else {
                    this.thisRow.setColumnValue(columnIndex - 1, StringUtils.getBytes(x, this.charEncoding));
                }
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void updateString(String columnName, String x) throws SQLException {
        try {
            this.updateString(this.findColumn(columnName), x);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void updateTime(int columnIndex, Time x) throws SQLException {
        try {
            if (!this.onInsertRow) {
                if (!this.doingUpdates) {
                    this.doingUpdates = true;
                    this.syncUpdate();
                }
                this.updater.setTime(columnIndex, x);
            } else {
                this.inserter.setTime(columnIndex, x);
                this.thisRow.setColumnValue(columnIndex - 1, this.inserter.getBytesRepresentation(columnIndex - 1));
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void updateTime(String columnName, Time x) throws SQLException {
        try {
            this.updateTime(this.findColumn(columnName), x);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        try {
            if (!this.onInsertRow) {
                if (!this.doingUpdates) {
                    this.doingUpdates = true;
                    this.syncUpdate();
                }
                this.updater.setTimestamp(columnIndex, x);
            } else {
                this.inserter.setTimestamp(columnIndex, x);
                this.thisRow.setColumnValue(columnIndex - 1, this.inserter.getBytesRepresentation(columnIndex - 1));
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        try {
            this.updateTimestamp(this.findColumn(columnName), x);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        try {
            throw SQLError.notUpdatable();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        try {
            throw SQLError.notUpdatable();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        try {
            throw SQLError.notUpdatable();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        try {
            throw SQLError.notUpdatable();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        try {
            throw SQLError.notUpdatable();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        try {
            throw SQLError.notUpdatable();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        try {
            throw SQLError.notUpdatable();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        try {
            throw SQLError.notUpdatable();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        try {
            throw SQLError.notUpdatable();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        try {
            throw SQLError.notUpdatable();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        try {
            throw SQLError.notUpdatable();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        try {
            this.updateNCharacterStream(columnIndex, x, (int)length);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        try {
            throw SQLError.notUpdatable();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        try {
            throw SQLError.notUpdatable();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        try {
            throw SQLError.notUpdatable();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        try {
            throw SQLError.notUpdatable();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        try {
            this.updateAsciiStream(this.findColumn(columnLabel), x);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        try {
            this.updateAsciiStream(this.findColumn(columnLabel), x, length);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        try {
            this.updateBinaryStream(this.findColumn(columnLabel), x);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        try {
            this.updateBinaryStream(this.findColumn(columnLabel), x, length);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        try {
            this.updateBlob(this.findColumn(columnLabel), inputStream);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        try {
            this.updateBlob(this.findColumn(columnLabel), inputStream, length);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        try {
            this.updateCharacterStream(this.findColumn(columnLabel), reader);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        try {
            this.updateCharacterStream(this.findColumn(columnLabel), reader, length);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        try {
            this.updateClob(this.findColumn(columnLabel), reader);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        try {
            this.updateClob(this.findColumn(columnLabel), reader, length);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        try {
            this.updateNCharacterStream(this.findColumn(columnLabel), reader);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        try {
            this.updateNCharacterStream(this.findColumn(columnLabel), reader, length);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        try {
            this.updateNClob(this.findColumn(columnLabel), reader);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        try {
            this.updateNClob(this.findColumn(columnLabel), reader, length);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        try {
            this.updateSQLXML(this.findColumn(columnLabel), xmlObject);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void updateNCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        String fieldEncoding = this.fields[columnIndex - 1].getEncoding();
        if (fieldEncoding == null || !fieldEncoding.equals("UTF-8")) {
            throw new SQLException(Messages.getString("ResultSet.16"));
        }
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setNCharacterStream(columnIndex, x, length);
        } else {
            this.inserter.setNCharacterStream(columnIndex, x, length);
            if (x == null) {
                this.thisRow.setColumnValue(columnIndex - 1, null);
            } else {
                this.thisRow.setColumnValue(columnIndex - 1, STREAM_DATA_MARKER);
            }
        }
    }

    @Override
    public synchronized void updateNCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.updateNCharacterStream(this.findColumn(columnName), reader, length);
    }

    @Override
    public void updateNClob(int columnIndex, java.sql.NClob nClob) throws SQLException {
        try {
            String fieldEncoding = this.fields[columnIndex - 1].getEncoding();
            if (fieldEncoding == null || !fieldEncoding.equals("UTF-8")) {
                throw new SQLException(Messages.getString("ResultSet.17"));
            }
            if (nClob == null) {
                this.updateNull(columnIndex);
            } else {
                this.updateNCharacterStream(columnIndex, nClob.getCharacterStream(), (int)nClob.length());
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void updateNClob(String columnName, java.sql.NClob nClob) throws SQLException {
        try {
            this.updateNClob(this.findColumn(columnName), nClob);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void updateNString(int columnIndex, String x) throws SQLException {
        try {
            String fieldEncoding = this.fields[columnIndex - 1].getEncoding();
            if (fieldEncoding == null || !fieldEncoding.equals("UTF-8")) {
                throw new SQLException(Messages.getString("ResultSet.18"));
            }
            if (!this.onInsertRow) {
                if (!this.doingUpdates) {
                    this.doingUpdates = true;
                    this.syncUpdate();
                }
                this.updater.setNString(columnIndex, x);
            } else {
                this.inserter.setNString(columnIndex, x);
                if (x == null) {
                    this.thisRow.setColumnValue(columnIndex - 1, null);
                } else {
                    this.thisRow.setColumnValue(columnIndex - 1, StringUtils.getBytes(x, fieldEncoding));
                }
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void updateNString(String columnName, String x) throws SQLException {
        try {
            this.updateNString(this.findColumn(columnName), x);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        try {
            throw SQLError.createSQLFeatureNotSupportedException();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        try {
            String fieldEncoding = this.fields[columnIndex - 1].getEncoding();
            if (fieldEncoding == null || !fieldEncoding.equals("UTF-8")) {
                throw new SQLException(Messages.getString("ResultSet.11"));
            }
            return this.getCharacterStream(columnIndex);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public Reader getNCharacterStream(String columnName) throws SQLException {
        try {
            return this.getNCharacterStream(this.findColumn(columnName));
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public java.sql.NClob getNClob(int columnIndex) throws SQLException {
        try {
            String fieldEncoding = this.fields[columnIndex - 1].getEncoding();
            if (fieldEncoding == null || !fieldEncoding.equals("UTF-8")) {
                throw new SQLException("Can not call getNClob() when field's charset isn't UTF-8");
            }
            String asString = this.getStringForNClob(columnIndex);
            if (asString == null) {
                return null;
            }
            return new NClob(asString, this.getExceptionInterceptor());
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public java.sql.NClob getNClob(String columnName) throws SQLException {
        try {
            return this.getNClob(this.findColumn(columnName));
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        try {
            String fieldEncoding = this.fields[columnIndex - 1].getEncoding();
            if (fieldEncoding == null || !fieldEncoding.equals("UTF-8")) {
                throw new SQLException("Can not call getNString() when field's charset isn't UTF-8");
            }
            return this.getString(columnIndex);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public String getNString(String columnName) throws SQLException {
        try {
            return this.getNString(this.findColumn(columnName));
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        try {
            throw SQLError.createSQLFeatureNotSupportedException();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        try {
            return this.getRowId(this.findColumn(columnLabel));
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        try {
            return new MysqlSQLXML(this, columnIndex, this.getExceptionInterceptor());
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        try {
            return this.getSQLXML(this.findColumn(columnLabel));
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    private String getStringForNClob(int columnIndex) throws SQLException {
        String asString = null;
        String forcedEncoding = "UTF-8";
        try {
            byte[] asBytes = null;
            asBytes = this.getBytes(columnIndex);
            if (asBytes != null) {
                asString = new String(asBytes, forcedEncoding);
            }
        }
        catch (UnsupportedEncodingException uee) {
            throw SQLError.createSQLException("Unsupported character encoding " + forcedEncoding, "S1009", this.getExceptionInterceptor());
        }
        return asString;
    }

    @Override
    public synchronized boolean isClosed() throws SQLException {
        try {
            return this.isClosed;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        try {
            this.checkClosed();
            return iface.isInstance(this);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            try {
                return iface.cast(this);
            }
            catch (ClassCastException cce) {
                throw SQLError.createSQLException("Unable to unwrap to " + iface.toString(), "S1009", this.getExceptionInterceptor());
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }
}

