// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_ASSEMBLER_COND_RD_RN_RM_MULS_A32_H_
#define VIXL_ASSEMBLER_COND_RD_RN_RM_MULS_A32_H_

const byte kInstruction_muls_hi_r1_r9_r5[] = {
  0x99, 0x05, 0x11, 0x80 // muls hi r1 r9 r5
};
const byte kInstruction_muls_pl_r8_r6_r2[] = {
  0x96, 0x02, 0x18, 0x50 // muls pl r8 r6 r2
};
const byte kInstruction_muls_hi_r5_r8_r2[] = {
  0x98, 0x02, 0x15, 0x80 // muls hi r5 r8 r2
};
const byte kInstruction_muls_vc_r9_r2_r7[] = {
  0x92, 0x07, 0x19, 0x70 // muls vc r9 r2 r7
};
const byte kInstruction_muls_lt_r4_r6_r3[] = {
  0x96, 0x03, 0x14, 0xb0 // muls lt r4 r6 r3
};
const byte kInstruction_muls_le_r11_r6_r2[] = {
  0x96, 0x02, 0x1b, 0xd0 // muls le r11 r6 r2
};
const byte kInstruction_muls_cc_r8_r14_r4[] = {
  0x9e, 0x04, 0x18, 0x30 // muls cc r8 r14 r4
};
const byte kInstruction_muls_le_r5_r14_r6[] = {
  0x9e, 0x06, 0x15, 0xd0 // muls le r5 r14 r6
};
const byte kInstruction_muls_lt_r6_r1_r0[] = {
  0x91, 0x00, 0x16, 0xb0 // muls lt r6 r1 r0
};
const byte kInstruction_muls_lt_r5_r0_r9[] = {
  0x90, 0x09, 0x15, 0xb0 // muls lt r5 r0 r9
};
const byte kInstruction_muls_le_r8_r12_r7[] = {
  0x9c, 0x07, 0x18, 0xd0 // muls le r8 r12 r7
};
const byte kInstruction_muls_eq_r7_r14_r6[] = {
  0x9e, 0x06, 0x17, 0x00 // muls eq r7 r14 r6
};
const byte kInstruction_muls_cs_r7_r4_r6[] = {
  0x94, 0x06, 0x17, 0x20 // muls cs r7 r4 r6
};
const byte kInstruction_muls_gt_r9_r6_r9[] = {
  0x96, 0x09, 0x19, 0xc0 // muls gt r9 r6 r9
};
const byte kInstruction_muls_ne_r13_r9_r1[] = {
  0x99, 0x01, 0x1d, 0x10 // muls ne r13 r9 r1
};
const byte kInstruction_muls_ge_r13_r1_r13[] = {
  0x91, 0x0d, 0x1d, 0xa0 // muls ge r13 r1 r13
};
const byte kInstruction_muls_ls_r8_r10_r2[] = {
  0x9a, 0x02, 0x18, 0x90 // muls ls r8 r10 r2
};
const byte kInstruction_muls_hi_r0_r13_r5[] = {
  0x9d, 0x05, 0x10, 0x80 // muls hi r0 r13 r5
};
const byte kInstruction_muls_pl_r13_r7_r8[] = {
  0x97, 0x08, 0x1d, 0x50 // muls pl r13 r7 r8
};
const byte kInstruction_muls_ge_r4_r13_r11[] = {
  0x9d, 0x0b, 0x14, 0xa0 // muls ge r4 r13 r11
};
const byte kInstruction_muls_cs_r5_r10_r5[] = {
  0x9a, 0x05, 0x15, 0x20 // muls cs r5 r10 r5
};
const byte kInstruction_muls_cs_r5_r4_r3[] = {
  0x94, 0x03, 0x15, 0x20 // muls cs r5 r4 r3
};
const byte kInstruction_muls_ls_r6_r14_r8[] = {
  0x9e, 0x08, 0x16, 0x90 // muls ls r6 r14 r8
};
const byte kInstruction_muls_vs_r3_r8_r6[] = {
  0x98, 0x06, 0x13, 0x60 // muls vs r3 r8 r6
};
const byte kInstruction_muls_vc_r7_r12_r3[] = {
  0x9c, 0x03, 0x17, 0x70 // muls vc r7 r12 r3
};
const byte kInstruction_muls_ge_r1_r4_r1[] = {
  0x94, 0x01, 0x11, 0xa0 // muls ge r1 r4 r1
};
const byte kInstruction_muls_cc_r4_r7_r10[] = {
  0x97, 0x0a, 0x14, 0x30 // muls cc r4 r7 r10
};
const byte kInstruction_muls_cc_r2_r0_r13[] = {
  0x90, 0x0d, 0x12, 0x30 // muls cc r2 r0 r13
};
const byte kInstruction_muls_vs_r9_r6_r8[] = {
  0x96, 0x08, 0x19, 0x60 // muls vs r9 r6 r8
};
const byte kInstruction_muls_cs_r14_r11_r13[] = {
  0x9b, 0x0d, 0x1e, 0x20 // muls cs r14 r11 r13
};
const byte kInstruction_muls_pl_r5_r8_r4[] = {
  0x98, 0x04, 0x15, 0x50 // muls pl r5 r8 r4
};
const byte kInstruction_muls_pl_r2_r3_r7[] = {
  0x93, 0x07, 0x12, 0x50 // muls pl r2 r3 r7
};
const byte kInstruction_muls_cs_r7_r12_r14[] = {
  0x9c, 0x0e, 0x17, 0x20 // muls cs r7 r12 r14
};
const byte kInstruction_muls_hi_r6_r6_r1[] = {
  0x96, 0x01, 0x16, 0x80 // muls hi r6 r6 r1
};
const byte kInstruction_muls_cc_r6_r9_r6[] = {
  0x99, 0x06, 0x16, 0x30 // muls cc r6 r9 r6
};
const byte kInstruction_muls_ne_r12_r12_r0[] = {
  0x9c, 0x00, 0x1c, 0x10 // muls ne r12 r12 r0
};
const byte kInstruction_muls_cc_r9_r3_r8[] = {
  0x93, 0x08, 0x19, 0x30 // muls cc r9 r3 r8
};
const byte kInstruction_muls_mi_r13_r6_r1[] = {
  0x96, 0x01, 0x1d, 0x40 // muls mi r13 r6 r1
};
const byte kInstruction_muls_lt_r4_r8_r6[] = {
  0x98, 0x06, 0x14, 0xb0 // muls lt r4 r8 r6
};
const byte kInstruction_muls_hi_r11_r5_r9[] = {
  0x95, 0x09, 0x1b, 0x80 // muls hi r11 r5 r9
};
const byte kInstruction_muls_cc_r6_r10_r6[] = {
  0x9a, 0x06, 0x16, 0x30 // muls cc r6 r10 r6
};
const byte kInstruction_muls_eq_r10_r10_r5[] = {
  0x9a, 0x05, 0x1a, 0x00 // muls eq r10 r10 r5
};
const byte kInstruction_muls_al_r5_r4_r11[] = {
  0x94, 0x0b, 0x15, 0xe0 // muls al r5 r4 r11
};
const byte kInstruction_muls_pl_r11_r11_r2[] = {
  0x9b, 0x02, 0x1b, 0x50 // muls pl r11 r11 r2
};
const byte kInstruction_muls_ls_r6_r14_r12[] = {
  0x9e, 0x0c, 0x16, 0x90 // muls ls r6 r14 r12
};
const byte kInstruction_muls_vc_r7_r7_r2[] = {
  0x97, 0x02, 0x17, 0x70 // muls vc r7 r7 r2
};
const byte kInstruction_muls_eq_r10_r8_r4[] = {
  0x98, 0x04, 0x1a, 0x00 // muls eq r10 r8 r4
};
const byte kInstruction_muls_al_r14_r7_r2[] = {
  0x97, 0x02, 0x1e, 0xe0 // muls al r14 r7 r2
};
const byte kInstruction_muls_cs_r3_r11_r10[] = {
  0x9b, 0x0a, 0x13, 0x20 // muls cs r3 r11 r10
};
const byte kInstruction_muls_ls_r11_r4_r0[] = {
  0x94, 0x00, 0x1b, 0x90 // muls ls r11 r4 r0
};
const byte kInstruction_muls_hi_r11_r8_r9[] = {
  0x98, 0x09, 0x1b, 0x80 // muls hi r11 r8 r9
};
const byte kInstruction_muls_vs_r2_r14_r13[] = {
  0x9e, 0x0d, 0x12, 0x60 // muls vs r2 r14 r13
};
const byte kInstruction_muls_al_r1_r13_r9[] = {
  0x9d, 0x09, 0x11, 0xe0 // muls al r1 r13 r9
};
const byte kInstruction_muls_eq_r3_r9_r13[] = {
  0x99, 0x0d, 0x13, 0x00 // muls eq r3 r9 r13
};
const byte kInstruction_muls_ge_r10_r3_r13[] = {
  0x93, 0x0d, 0x1a, 0xa0 // muls ge r10 r3 r13
};
const byte kInstruction_muls_pl_r8_r5_r10[] = {
  0x95, 0x0a, 0x18, 0x50 // muls pl r8 r5 r10
};
const byte kInstruction_muls_vc_r8_r11_r6[] = {
  0x9b, 0x06, 0x18, 0x70 // muls vc r8 r11 r6
};
const byte kInstruction_muls_eq_r0_r0_r5[] = {
  0x90, 0x05, 0x10, 0x00 // muls eq r0 r0 r5
};
const byte kInstruction_muls_ne_r6_r5_r8[] = {
  0x95, 0x08, 0x16, 0x10 // muls ne r6 r5 r8
};
const byte kInstruction_muls_hi_r5_r13_r3[] = {
  0x9d, 0x03, 0x15, 0x80 // muls hi r5 r13 r3
};
const byte kInstruction_muls_ne_r11_r14_r14[] = {
  0x9e, 0x0e, 0x1b, 0x10 // muls ne r11 r14 r14
};
const byte kInstruction_muls_mi_r1_r0_r6[] = {
  0x90, 0x06, 0x11, 0x40 // muls mi r1 r0 r6
};
const byte kInstruction_muls_le_r14_r8_r2[] = {
  0x98, 0x02, 0x1e, 0xd0 // muls le r14 r8 r2
};
const byte kInstruction_muls_eq_r9_r6_r5[] = {
  0x96, 0x05, 0x19, 0x00 // muls eq r9 r6 r5
};
const byte kInstruction_muls_eq_r11_r0_r13[] = {
  0x90, 0x0d, 0x1b, 0x00 // muls eq r11 r0 r13
};
const byte kInstruction_muls_pl_r4_r5_r14[] = {
  0x95, 0x0e, 0x14, 0x50 // muls pl r4 r5 r14
};
const byte kInstruction_muls_cs_r13_r5_r13[] = {
  0x95, 0x0d, 0x1d, 0x20 // muls cs r13 r5 r13
};
const byte kInstruction_muls_mi_r0_r13_r8[] = {
  0x9d, 0x08, 0x10, 0x40 // muls mi r0 r13 r8
};
const byte kInstruction_muls_lt_r2_r13_r3[] = {
  0x9d, 0x03, 0x12, 0xb0 // muls lt r2 r13 r3
};
const byte kInstruction_muls_ls_r8_r1_r11[] = {
  0x91, 0x0b, 0x18, 0x90 // muls ls r8 r1 r11
};
const byte kInstruction_muls_vc_r14_r11_r8[] = {
  0x9b, 0x08, 0x1e, 0x70 // muls vc r14 r11 r8
};
const byte kInstruction_muls_lt_r4_r13_r12[] = {
  0x9d, 0x0c, 0x14, 0xb0 // muls lt r4 r13 r12
};
const byte kInstruction_muls_eq_r2_r1_r14[] = {
  0x91, 0x0e, 0x12, 0x00 // muls eq r2 r1 r14
};
const byte kInstruction_muls_eq_r9_r4_r14[] = {
  0x94, 0x0e, 0x19, 0x00 // muls eq r9 r4 r14
};
const byte kInstruction_muls_hi_r10_r6_r13[] = {
  0x96, 0x0d, 0x1a, 0x80 // muls hi r10 r6 r13
};
const byte kInstruction_muls_ge_r12_r9_r4[] = {
  0x99, 0x04, 0x1c, 0xa0 // muls ge r12 r9 r4
};
const byte kInstruction_muls_le_r9_r11_r14[] = {
  0x9b, 0x0e, 0x19, 0xd0 // muls le r9 r11 r14
};
const byte kInstruction_muls_ls_r0_r9_r5[] = {
  0x99, 0x05, 0x10, 0x90 // muls ls r0 r9 r5
};
const byte kInstruction_muls_mi_r2_r3_r8[] = {
  0x93, 0x08, 0x12, 0x40 // muls mi r2 r3 r8
};
const byte kInstruction_muls_ne_r14_r10_r14[] = {
  0x9a, 0x0e, 0x1e, 0x10 // muls ne r14 r10 r14
};
const byte kInstruction_muls_eq_r6_r2_r10[] = {
  0x92, 0x0a, 0x16, 0x00 // muls eq r6 r2 r10
};
const byte kInstruction_muls_lt_r11_r0_r12[] = {
  0x90, 0x0c, 0x1b, 0xb0 // muls lt r11 r0 r12
};
const byte kInstruction_muls_ne_r1_r12_r10[] = {
  0x9c, 0x0a, 0x11, 0x10 // muls ne r1 r12 r10
};
const byte kInstruction_muls_cc_r1_r0_r2[] = {
  0x90, 0x02, 0x11, 0x30 // muls cc r1 r0 r2
};
const byte kInstruction_muls_al_r5_r5_r7[] = {
  0x95, 0x07, 0x15, 0xe0 // muls al r5 r5 r7
};
const byte kInstruction_muls_hi_r7_r13_r1[] = {
  0x9d, 0x01, 0x17, 0x80 // muls hi r7 r13 r1
};
const byte kInstruction_muls_cs_r4_r4_r9[] = {
  0x94, 0x09, 0x14, 0x20 // muls cs r4 r4 r9
};
const byte kInstruction_muls_eq_r14_r4_r14[] = {
  0x94, 0x0e, 0x1e, 0x00 // muls eq r14 r4 r14
};
const byte kInstruction_muls_vs_r10_r5_r14[] = {
  0x95, 0x0e, 0x1a, 0x60 // muls vs r10 r5 r14
};
const byte kInstruction_muls_gt_r4_r3_r11[] = {
  0x93, 0x0b, 0x14, 0xc0 // muls gt r4 r3 r11
};
const byte kInstruction_muls_ne_r14_r10_r12[] = {
  0x9a, 0x0c, 0x1e, 0x10 // muls ne r14 r10 r12
};
const byte kInstruction_muls_vs_r2_r11_r0[] = {
  0x9b, 0x00, 0x12, 0x60 // muls vs r2 r11 r0
};
const byte kInstruction_muls_ge_r5_r12_r7[] = {
  0x9c, 0x07, 0x15, 0xa0 // muls ge r5 r12 r7
};
const byte kInstruction_muls_mi_r7_r14_r6[] = {
  0x9e, 0x06, 0x17, 0x40 // muls mi r7 r14 r6
};
const byte kInstruction_muls_gt_r8_r3_r8[] = {
  0x93, 0x08, 0x18, 0xc0 // muls gt r8 r3 r8
};
const byte kInstruction_muls_hi_r9_r14_r3[] = {
  0x9e, 0x03, 0x19, 0x80 // muls hi r9 r14 r3
};
const byte kInstruction_muls_vc_r2_r11_r2[] = {
  0x9b, 0x02, 0x12, 0x70 // muls vc r2 r11 r2
};
const byte kInstruction_muls_hi_r11_r7_r12[] = {
  0x97, 0x0c, 0x1b, 0x80 // muls hi r11 r7 r12
};
const byte kInstruction_muls_cs_r6_r4_r11[] = {
  0x94, 0x0b, 0x16, 0x20 // muls cs r6 r4 r11
};
const byte kInstruction_muls_cs_r12_r5_r9[] = {
  0x95, 0x09, 0x1c, 0x20 // muls cs r12 r5 r9
};
const byte kInstruction_muls_ls_r5_r10_r5[] = {
  0x9a, 0x05, 0x15, 0x90 // muls ls r5 r10 r5
};
const byte kInstruction_muls_ls_r0_r9_r13[] = {
  0x99, 0x0d, 0x10, 0x90 // muls ls r0 r9 r13
};
const byte kInstruction_muls_lt_r3_r3_r5[] = {
  0x93, 0x05, 0x13, 0xb0 // muls lt r3 r3 r5
};
const byte kInstruction_muls_mi_r0_r12_r8[] = {
  0x9c, 0x08, 0x10, 0x40 // muls mi r0 r12 r8
};
const byte kInstruction_muls_pl_r3_r12_r12[] = {
  0x9c, 0x0c, 0x13, 0x50 // muls pl r3 r12 r12
};
const byte kInstruction_muls_eq_r8_r12_r5[] = {
  0x9c, 0x05, 0x18, 0x00 // muls eq r8 r12 r5
};
const byte kInstruction_muls_cc_r7_r8_r1[] = {
  0x98, 0x01, 0x17, 0x30 // muls cc r7 r8 r1
};
const byte kInstruction_muls_hi_r2_r13_r10[] = {
  0x9d, 0x0a, 0x12, 0x80 // muls hi r2 r13 r10
};
const byte kInstruction_muls_al_r7_r10_r10[] = {
  0x9a, 0x0a, 0x17, 0xe0 // muls al r7 r10 r10
};
const byte kInstruction_muls_vc_r1_r12_r2[] = {
  0x9c, 0x02, 0x11, 0x70 // muls vc r1 r12 r2
};
const byte kInstruction_muls_cc_r8_r5_r8[] = {
  0x95, 0x08, 0x18, 0x30 // muls cc r8 r5 r8
};
const byte kInstruction_muls_ls_r3_r7_r9[] = {
  0x97, 0x09, 0x13, 0x90 // muls ls r3 r7 r9
};
const byte kInstruction_muls_al_r8_r10_r8[] = {
  0x9a, 0x08, 0x18, 0xe0 // muls al r8 r10 r8
};
const byte kInstruction_muls_lt_r4_r12_r10[] = {
  0x9c, 0x0a, 0x14, 0xb0 // muls lt r4 r12 r10
};
const byte kInstruction_muls_ge_r10_r5_r11[] = {
  0x95, 0x0b, 0x1a, 0xa0 // muls ge r10 r5 r11
};
const byte kInstruction_muls_ls_r3_r14_r4[] = {
  0x9e, 0x04, 0x13, 0x90 // muls ls r3 r14 r4
};
const byte kInstruction_muls_hi_r3_r6_r12[] = {
  0x96, 0x0c, 0x13, 0x80 // muls hi r3 r6 r12
};
const byte kInstruction_muls_hi_r6_r0_r4[] = {
  0x90, 0x04, 0x16, 0x80 // muls hi r6 r0 r4
};
const byte kInstruction_muls_al_r11_r6_r0[] = {
  0x96, 0x00, 0x1b, 0xe0 // muls al r11 r6 r0
};
const byte kInstruction_muls_mi_r3_r1_r9[] = {
  0x91, 0x09, 0x13, 0x40 // muls mi r3 r1 r9
};
const byte kInstruction_muls_mi_r12_r13_r0[] = {
  0x9d, 0x00, 0x1c, 0x40 // muls mi r12 r13 r0
};
const byte kInstruction_muls_le_r1_r2_r5[] = {
  0x92, 0x05, 0x11, 0xd0 // muls le r1 r2 r5
};
const byte kInstruction_muls_hi_r4_r3_r14[] = {
  0x93, 0x0e, 0x14, 0x80 // muls hi r4 r3 r14
};
const byte kInstruction_muls_eq_r6_r11_r11[] = {
  0x9b, 0x0b, 0x16, 0x00 // muls eq r6 r11 r11
};
const byte kInstruction_muls_cc_r14_r11_r14[] = {
  0x9b, 0x0e, 0x1e, 0x30 // muls cc r14 r11 r14
};
const byte kInstruction_muls_hi_r4_r10_r0[] = {
  0x9a, 0x00, 0x14, 0x80 // muls hi r4 r10 r0
};
const byte kInstruction_muls_cc_r7_r11_r1[] = {
  0x9b, 0x01, 0x17, 0x30 // muls cc r7 r11 r1
};
const byte kInstruction_muls_mi_r14_r6_r10[] = {
  0x96, 0x0a, 0x1e, 0x40 // muls mi r14 r6 r10
};
const byte kInstruction_muls_eq_r2_r0_r11[] = {
  0x90, 0x0b, 0x12, 0x00 // muls eq r2 r0 r11
};
const byte kInstruction_muls_mi_r13_r5_r12[] = {
  0x95, 0x0c, 0x1d, 0x40 // muls mi r13 r5 r12
};
const byte kInstruction_muls_eq_r2_r12_r5[] = {
  0x9c, 0x05, 0x12, 0x00 // muls eq r2 r12 r5
};
const byte kInstruction_muls_le_r12_r0_r2[] = {
  0x90, 0x02, 0x1c, 0xd0 // muls le r12 r0 r2
};
const byte kInstruction_muls_vc_r10_r10_r9[] = {
  0x9a, 0x09, 0x1a, 0x70 // muls vc r10 r10 r9
};
const byte kInstruction_muls_ls_r11_r11_r8[] = {
  0x9b, 0x08, 0x1b, 0x90 // muls ls r11 r11 r8
};
const byte kInstruction_muls_hi_r10_r11_r9[] = {
  0x9b, 0x09, 0x1a, 0x80 // muls hi r10 r11 r9
};
const byte kInstruction_muls_vs_r7_r12_r14[] = {
  0x9c, 0x0e, 0x17, 0x60 // muls vs r7 r12 r14
};
const byte kInstruction_muls_gt_r11_r14_r12[] = {
  0x9e, 0x0c, 0x1b, 0xc0 // muls gt r11 r14 r12
};
const byte kInstruction_muls_vs_r0_r12_r8[] = {
  0x9c, 0x08, 0x10, 0x60 // muls vs r0 r12 r8
};
const byte kInstruction_muls_al_r0_r5_r7[] = {
  0x95, 0x07, 0x10, 0xe0 // muls al r0 r5 r7
};
const byte kInstruction_muls_hi_r5_r13_r8[] = {
  0x9d, 0x08, 0x15, 0x80 // muls hi r5 r13 r8
};
const byte kInstruction_muls_le_r9_r9_r7[] = {
  0x99, 0x07, 0x19, 0xd0 // muls le r9 r9 r7
};
const byte kInstruction_muls_cc_r4_r9_r5[] = {
  0x99, 0x05, 0x14, 0x30 // muls cc r4 r9 r5
};
const byte kInstruction_muls_vs_r8_r1_r3[] = {
  0x91, 0x03, 0x18, 0x60 // muls vs r8 r1 r3
};
const byte kInstruction_muls_cc_r0_r10_r12[] = {
  0x9a, 0x0c, 0x10, 0x30 // muls cc r0 r10 r12
};
const byte kInstruction_muls_eq_r7_r14_r0[] = {
  0x9e, 0x00, 0x17, 0x00 // muls eq r7 r14 r0
};
const byte kInstruction_muls_vs_r12_r9_r11[] = {
  0x99, 0x0b, 0x1c, 0x60 // muls vs r12 r9 r11
};
const byte kInstruction_muls_gt_r5_r9_r11[] = {
  0x99, 0x0b, 0x15, 0xc0 // muls gt r5 r9 r11
};
const byte kInstruction_muls_cs_r14_r13_r7[] = {
  0x9d, 0x07, 0x1e, 0x20 // muls cs r14 r13 r7
};
const byte kInstruction_muls_mi_r11_r3_r10[] = {
  0x93, 0x0a, 0x1b, 0x40 // muls mi r11 r3 r10
};
const byte kInstruction_muls_hi_r11_r8_r12[] = {
  0x98, 0x0c, 0x1b, 0x80 // muls hi r11 r8 r12
};
const byte kInstruction_muls_cs_r3_r8_r13[] = {
  0x98, 0x0d, 0x13, 0x20 // muls cs r3 r8 r13
};
const byte kInstruction_muls_pl_r10_r12_r6[] = {
  0x9c, 0x06, 0x1a, 0x50 // muls pl r10 r12 r6
};
const byte kInstruction_muls_vc_r7_r3_r2[] = {
  0x93, 0x02, 0x17, 0x70 // muls vc r7 r3 r2
};
const byte kInstruction_muls_mi_r9_r0_r8[] = {
  0x90, 0x08, 0x19, 0x40 // muls mi r9 r0 r8
};
const byte kInstruction_muls_eq_r2_r13_r7[] = {
  0x9d, 0x07, 0x12, 0x00 // muls eq r2 r13 r7
};
const byte kInstruction_muls_ne_r2_r14_r0[] = {
  0x9e, 0x00, 0x12, 0x10 // muls ne r2 r14 r0
};
const byte kInstruction_muls_vs_r4_r10_r0[] = {
  0x9a, 0x00, 0x14, 0x60 // muls vs r4 r10 r0
};
const byte kInstruction_muls_ls_r0_r2_r2[] = {
  0x92, 0x02, 0x10, 0x90 // muls ls r0 r2 r2
};
const byte kInstruction_muls_cc_r1_r6_r0[] = {
  0x96, 0x00, 0x11, 0x30 // muls cc r1 r6 r0
};
const byte kInstruction_muls_lt_r12_r0_r8[] = {
  0x90, 0x08, 0x1c, 0xb0 // muls lt r12 r0 r8
};
const byte kInstruction_muls_cc_r9_r3_r14[] = {
  0x93, 0x0e, 0x19, 0x30 // muls cc r9 r3 r14
};
const byte kInstruction_muls_vs_r7_r9_r1[] = {
  0x99, 0x01, 0x17, 0x60 // muls vs r7 r9 r1
};
const byte kInstruction_muls_eq_r11_r9_r14[] = {
  0x99, 0x0e, 0x1b, 0x00 // muls eq r11 r9 r14
};
const byte kInstruction_muls_pl_r6_r10_r4[] = {
  0x9a, 0x04, 0x16, 0x50 // muls pl r6 r10 r4
};
const byte kInstruction_muls_ne_r8_r5_r6[] = {
  0x95, 0x06, 0x18, 0x10 // muls ne r8 r5 r6
};
const byte kInstruction_muls_cs_r0_r6_r2[] = {
  0x96, 0x02, 0x10, 0x20 // muls cs r0 r6 r2
};
const byte kInstruction_muls_eq_r11_r12_r4[] = {
  0x9c, 0x04, 0x1b, 0x00 // muls eq r11 r12 r4
};
const byte kInstruction_muls_lt_r14_r3_r14[] = {
  0x93, 0x0e, 0x1e, 0xb0 // muls lt r14 r3 r14
};
const byte kInstruction_muls_le_r7_r12_r14[] = {
  0x9c, 0x0e, 0x17, 0xd0 // muls le r7 r12 r14
};
const byte kInstruction_muls_hi_r2_r9_r9[] = {
  0x99, 0x09, 0x12, 0x80 // muls hi r2 r9 r9
};
const byte kInstruction_muls_ne_r8_r1_r0[] = {
  0x91, 0x00, 0x18, 0x10 // muls ne r8 r1 r0
};
const byte kInstruction_muls_cc_r5_r11_r2[] = {
  0x9b, 0x02, 0x15, 0x30 // muls cc r5 r11 r2
};
const byte kInstruction_muls_hi_r0_r1_r2[] = {
  0x91, 0x02, 0x10, 0x80 // muls hi r0 r1 r2
};
const byte kInstruction_muls_al_r4_r9_r4[] = {
  0x99, 0x04, 0x14, 0xe0 // muls al r4 r9 r4
};
const byte kInstruction_muls_cs_r12_r7_r14[] = {
  0x97, 0x0e, 0x1c, 0x20 // muls cs r12 r7 r14
};
const byte kInstruction_muls_cc_r4_r12_r10[] = {
  0x9c, 0x0a, 0x14, 0x30 // muls cc r4 r12 r10
};
const byte kInstruction_muls_al_r3_r5_r10[] = {
  0x95, 0x0a, 0x13, 0xe0 // muls al r3 r5 r10
};
const byte kInstruction_muls_mi_r5_r3_r7[] = {
  0x93, 0x07, 0x15, 0x40 // muls mi r5 r3 r7
};
const byte kInstruction_muls_ls_r10_r6_r2[] = {
  0x96, 0x02, 0x1a, 0x90 // muls ls r10 r6 r2
};
const byte kInstruction_muls_mi_r0_r12_r11[] = {
  0x9c, 0x0b, 0x10, 0x40 // muls mi r0 r12 r11
};
const byte kInstruction_muls_vc_r12_r5_r6[] = {
  0x95, 0x06, 0x1c, 0x70 // muls vc r12 r5 r6
};
const byte kInstruction_muls_cs_r3_r9_r4[] = {
  0x99, 0x04, 0x13, 0x20 // muls cs r3 r9 r4
};
const byte kInstruction_muls_ls_r4_r9_r11[] = {
  0x99, 0x0b, 0x14, 0x90 // muls ls r4 r9 r11
};
const byte kInstruction_muls_le_r14_r8_r13[] = {
  0x98, 0x0d, 0x1e, 0xd0 // muls le r14 r8 r13
};
const byte kInstruction_muls_gt_r4_r10_r8[] = {
  0x9a, 0x08, 0x14, 0xc0 // muls gt r4 r10 r8
};
const byte kInstruction_muls_al_r6_r9_r9[] = {
  0x99, 0x09, 0x16, 0xe0 // muls al r6 r9 r9
};
const byte kInstruction_muls_ne_r8_r5_r12[] = {
  0x95, 0x0c, 0x18, 0x10 // muls ne r8 r5 r12
};
const byte kInstruction_muls_ne_r0_r4_r8[] = {
  0x94, 0x08, 0x10, 0x10 // muls ne r0 r4 r8
};
const byte kInstruction_muls_mi_r7_r13_r3[] = {
  0x9d, 0x03, 0x17, 0x40 // muls mi r7 r13 r3
};
const byte kInstruction_muls_cc_r11_r7_r0[] = {
  0x97, 0x00, 0x1b, 0x30 // muls cc r11 r7 r0
};
const byte kInstruction_muls_hi_r1_r0_r12[] = {
  0x90, 0x0c, 0x11, 0x80 // muls hi r1 r0 r12
};
const byte kInstruction_muls_lt_r8_r9_r3[] = {
  0x99, 0x03, 0x18, 0xb0 // muls lt r8 r9 r3
};
const byte kInstruction_muls_al_r0_r2_r1[] = {
  0x92, 0x01, 0x10, 0xe0 // muls al r0 r2 r1
};
const byte kInstruction_muls_vs_r4_r3_r14[] = {
  0x93, 0x0e, 0x14, 0x60 // muls vs r4 r3 r14
};
const byte kInstruction_muls_ge_r2_r11_r1[] = {
  0x9b, 0x01, 0x12, 0xa0 // muls ge r2 r11 r1
};
const byte kInstruction_muls_lt_r12_r9_r6[] = {
  0x99, 0x06, 0x1c, 0xb0 // muls lt r12 r9 r6
};
const byte kInstruction_muls_ls_r8_r2_r7[] = {
  0x92, 0x07, 0x18, 0x90 // muls ls r8 r2 r7
};
const byte kInstruction_muls_le_r8_r13_r3[] = {
  0x9d, 0x03, 0x18, 0xd0 // muls le r8 r13 r3
};
const byte kInstruction_muls_eq_r11_r13_r14[] = {
  0x9d, 0x0e, 0x1b, 0x00 // muls eq r11 r13 r14
};
const byte kInstruction_muls_lt_r1_r6_r13[] = {
  0x96, 0x0d, 0x11, 0xb0 // muls lt r1 r6 r13
};
const byte kInstruction_muls_cs_r3_r8_r11[] = {
  0x98, 0x0b, 0x13, 0x20 // muls cs r3 r8 r11
};
const byte kInstruction_muls_pl_r12_r5_r4[] = {
  0x95, 0x04, 0x1c, 0x50 // muls pl r12 r5 r4
};
const byte kInstruction_muls_eq_r8_r7_r2[] = {
  0x97, 0x02, 0x18, 0x00 // muls eq r8 r7 r2
};
const byte kInstruction_muls_ls_r2_r12_r2[] = {
  0x9c, 0x02, 0x12, 0x90 // muls ls r2 r12 r2
};
const byte kInstruction_muls_le_r14_r2_r3[] = {
  0x92, 0x03, 0x1e, 0xd0 // muls le r14 r2 r3
};
const byte kInstruction_muls_ge_r10_r11_r6[] = {
  0x9b, 0x06, 0x1a, 0xa0 // muls ge r10 r11 r6
};
const byte kInstruction_muls_hi_r0_r2_r2[] = {
  0x92, 0x02, 0x10, 0x80 // muls hi r0 r2 r2
};
const byte kInstruction_muls_ge_r2_r0_r2[] = {
  0x90, 0x02, 0x12, 0xa0 // muls ge r2 r0 r2
};
const byte kInstruction_muls_vs_r11_r14_r0[] = {
  0x9e, 0x00, 0x1b, 0x60 // muls vs r11 r14 r0
};
const byte kInstruction_muls_lt_r2_r0_r1[] = {
  0x90, 0x01, 0x12, 0xb0 // muls lt r2 r0 r1
};
const byte kInstruction_muls_cs_r2_r5_r11[] = {
  0x95, 0x0b, 0x12, 0x20 // muls cs r2 r5 r11
};
const byte kInstruction_muls_ls_r7_r14_r5[] = {
  0x9e, 0x05, 0x17, 0x90 // muls ls r7 r14 r5
};
const byte kInstruction_muls_pl_r0_r0_r3[] = {
  0x90, 0x03, 0x10, 0x50 // muls pl r0 r0 r3
};
const byte kInstruction_muls_ge_r6_r8_r8[] = {
  0x98, 0x08, 0x16, 0xa0 // muls ge r6 r8 r8
};
const byte kInstruction_muls_le_r11_r1_r10[] = {
  0x91, 0x0a, 0x1b, 0xd0 // muls le r11 r1 r10
};
const byte kInstruction_muls_vs_r5_r2_r7[] = {
  0x92, 0x07, 0x15, 0x60 // muls vs r5 r2 r7
};
const byte kInstruction_muls_ne_r4_r4_r8[] = {
  0x94, 0x08, 0x14, 0x10 // muls ne r4 r4 r8
};
const byte kInstruction_muls_cc_r9_r14_r13[] = {
  0x9e, 0x0d, 0x19, 0x30 // muls cc r9 r14 r13
};
const byte kInstruction_muls_hi_r14_r6_r3[] = {
  0x96, 0x03, 0x1e, 0x80 // muls hi r14 r6 r3
};
const byte kInstruction_muls_al_r0_r8_r0[] = {
  0x98, 0x00, 0x10, 0xe0 // muls al r0 r8 r0
};
const byte kInstruction_muls_lt_r6_r11_r1[] = {
  0x9b, 0x01, 0x16, 0xb0 // muls lt r6 r11 r1
};
const byte kInstruction_muls_ge_r7_r6_r12[] = {
  0x96, 0x0c, 0x17, 0xa0 // muls ge r7 r6 r12
};
const byte kInstruction_muls_cs_r4_r6_r14[] = {
  0x96, 0x0e, 0x14, 0x20 // muls cs r4 r6 r14
};
const byte kInstruction_muls_cs_r7_r6_r7[] = {
  0x96, 0x07, 0x17, 0x20 // muls cs r7 r6 r7
};
const byte kInstruction_muls_cs_r3_r7_r10[] = {
  0x97, 0x0a, 0x13, 0x20 // muls cs r3 r7 r10
};
const byte kInstruction_muls_ne_r0_r2_r1[] = {
  0x92, 0x01, 0x10, 0x10 // muls ne r0 r2 r1
};
const byte kInstruction_muls_vs_r9_r10_r13[] = {
  0x9a, 0x0d, 0x19, 0x60 // muls vs r9 r10 r13
};
const byte kInstruction_muls_vc_r11_r14_r12[] = {
  0x9e, 0x0c, 0x1b, 0x70 // muls vc r11 r14 r12
};
const byte kInstruction_muls_ge_r14_r8_r7[] = {
  0x98, 0x07, 0x1e, 0xa0 // muls ge r14 r8 r7
};
const byte kInstruction_muls_lt_r13_r0_r11[] = {
  0x90, 0x0b, 0x1d, 0xb0 // muls lt r13 r0 r11
};
const byte kInstruction_muls_lt_r14_r13_r4[] = {
  0x9d, 0x04, 0x1e, 0xb0 // muls lt r14 r13 r4
};
const byte kInstruction_muls_al_r1_r10_r9[] = {
  0x9a, 0x09, 0x11, 0xe0 // muls al r1 r10 r9
};
const byte kInstruction_muls_ge_r11_r14_r11[] = {
  0x9e, 0x0b, 0x1b, 0xa0 // muls ge r11 r14 r11
};
const byte kInstruction_muls_cs_r11_r4_r11[] = {
  0x94, 0x0b, 0x1b, 0x20 // muls cs r11 r4 r11
};
const byte kInstruction_muls_ge_r0_r14_r7[] = {
  0x9e, 0x07, 0x10, 0xa0 // muls ge r0 r14 r7
};
const byte kInstruction_muls_mi_r1_r2_r9[] = {
  0x92, 0x09, 0x11, 0x40 // muls mi r1 r2 r9
};
const byte kInstruction_muls_eq_r5_r12_r3[] = {
  0x9c, 0x03, 0x15, 0x00 // muls eq r5 r12 r3
};
const byte kInstruction_muls_ge_r1_r5_r12[] = {
  0x95, 0x0c, 0x11, 0xa0 // muls ge r1 r5 r12
};
const byte kInstruction_muls_lt_r10_r11_r4[] = {
  0x9b, 0x04, 0x1a, 0xb0 // muls lt r10 r11 r4
};
const byte kInstruction_muls_le_r1_r1_r5[] = {
  0x91, 0x05, 0x11, 0xd0 // muls le r1 r1 r5
};
const byte kInstruction_muls_al_r9_r1_r8[] = {
  0x91, 0x08, 0x19, 0xe0 // muls al r9 r1 r8
};
const byte kInstruction_muls_ne_r6_r8_r4[] = {
  0x98, 0x04, 0x16, 0x10 // muls ne r6 r8 r4
};
const byte kInstruction_muls_ge_r12_r2_r9[] = {
  0x92, 0x09, 0x1c, 0xa0 // muls ge r12 r2 r9
};
const byte kInstruction_muls_pl_r4_r3_r10[] = {
  0x93, 0x0a, 0x14, 0x50 // muls pl r4 r3 r10
};
const byte kInstruction_muls_eq_r14_r4_r11[] = {
  0x94, 0x0b, 0x1e, 0x00 // muls eq r14 r4 r11
};
const byte kInstruction_muls_cc_r9_r7_r6[] = {
  0x97, 0x06, 0x19, 0x30 // muls cc r9 r7 r6
};
const byte kInstruction_muls_ge_r12_r4_r5[] = {
  0x94, 0x05, 0x1c, 0xa0 // muls ge r12 r4 r5
};
const byte kInstruction_muls_hi_r2_r3_r4[] = {
  0x93, 0x04, 0x12, 0x80 // muls hi r2 r3 r4
};
const byte kInstruction_muls_cs_r0_r3_r1[] = {
  0x93, 0x01, 0x10, 0x20 // muls cs r0 r3 r1
};
const byte kInstruction_muls_hi_r6_r2_r8[] = {
  0x92, 0x08, 0x16, 0x80 // muls hi r6 r2 r8
};
const byte kInstruction_muls_cc_r3_r14_r13[] = {
  0x9e, 0x0d, 0x13, 0x30 // muls cc r3 r14 r13
};
const byte kInstruction_muls_gt_r11_r4_r7[] = {
  0x94, 0x07, 0x1b, 0xc0 // muls gt r11 r4 r7
};
const byte kInstruction_muls_hi_r5_r0_r12[] = {
  0x90, 0x0c, 0x15, 0x80 // muls hi r5 r0 r12
};
const byte kInstruction_muls_gt_r0_r14_r14[] = {
  0x9e, 0x0e, 0x10, 0xc0 // muls gt r0 r14 r14
};
const byte kInstruction_muls_hi_r9_r0_r10[] = {
  0x90, 0x0a, 0x19, 0x80 // muls hi r9 r0 r10
};
const byte kInstruction_muls_vc_r7_r11_r8[] = {
  0x9b, 0x08, 0x17, 0x70 // muls vc r7 r11 r8
};
const byte kInstruction_muls_pl_r11_r9_r6[] = {
  0x99, 0x06, 0x1b, 0x50 // muls pl r11 r9 r6
};
const byte kInstruction_muls_al_r3_r3_r7[] = {
  0x93, 0x07, 0x13, 0xe0 // muls al r3 r3 r7
};
const byte kInstruction_muls_mi_r5_r7_r9[] = {
  0x97, 0x09, 0x15, 0x40 // muls mi r5 r7 r9
};
const byte kInstruction_muls_cc_r11_r2_r4[] = {
  0x92, 0x04, 0x1b, 0x30 // muls cc r11 r2 r4
};
const byte kInstruction_muls_cc_r9_r13_r10[] = {
  0x9d, 0x0a, 0x19, 0x30 // muls cc r9 r13 r10
};
const byte kInstruction_muls_al_r5_r2_r6[] = {
  0x92, 0x06, 0x15, 0xe0 // muls al r5 r2 r6
};
const byte kInstruction_muls_ge_r9_r4_r6[] = {
  0x94, 0x06, 0x19, 0xa0 // muls ge r9 r4 r6
};
const byte kInstruction_muls_ls_r3_r3_r4[] = {
  0x93, 0x04, 0x13, 0x90 // muls ls r3 r3 r4
};
const byte kInstruction_muls_ge_r14_r1_r8[] = {
  0x91, 0x08, 0x1e, 0xa0 // muls ge r14 r1 r8
};
const byte kInstruction_muls_ls_r7_r12_r7[] = {
  0x9c, 0x07, 0x17, 0x90 // muls ls r7 r12 r7
};
const byte kInstruction_muls_al_r11_r10_r5[] = {
  0x9a, 0x05, 0x1b, 0xe0 // muls al r11 r10 r5
};
const byte kInstruction_muls_al_r7_r4_r6[] = {
  0x94, 0x06, 0x17, 0xe0 // muls al r7 r4 r6
};
const byte kInstruction_muls_vs_r12_r4_r10[] = {
  0x94, 0x0a, 0x1c, 0x60 // muls vs r12 r4 r10
};
const byte kInstruction_muls_eq_r4_r4_r4[] = {
  0x94, 0x04, 0x14, 0x00 // muls eq r4 r4 r4
};
const byte kInstruction_muls_vs_r6_r6_r12[] = {
  0x96, 0x0c, 0x16, 0x60 // muls vs r6 r6 r12
};
const byte kInstruction_muls_pl_r9_r3_r5[] = {
  0x93, 0x05, 0x19, 0x50 // muls pl r9 r3 r5
};
const byte kInstruction_muls_eq_r6_r5_r13[] = {
  0x95, 0x0d, 0x16, 0x00 // muls eq r6 r5 r13
};
const byte kInstruction_muls_cc_r8_r2_r12[] = {
  0x92, 0x0c, 0x18, 0x30 // muls cc r8 r2 r12
};
const byte kInstruction_muls_le_r4_r2_r0[] = {
  0x92, 0x00, 0x14, 0xd0 // muls le r4 r2 r0
};
const byte kInstruction_muls_lt_r7_r9_r8[] = {
  0x99, 0x08, 0x17, 0xb0 // muls lt r7 r9 r8
};
const byte kInstruction_muls_le_r4_r7_r11[] = {
  0x97, 0x0b, 0x14, 0xd0 // muls le r4 r7 r11
};
const byte kInstruction_muls_eq_r5_r7_r5[] = {
  0x97, 0x05, 0x15, 0x00 // muls eq r5 r7 r5
};
const byte kInstruction_muls_vc_r10_r7_r12[] = {
  0x97, 0x0c, 0x1a, 0x70 // muls vc r10 r7 r12
};
const byte kInstruction_muls_eq_r7_r10_r6[] = {
  0x9a, 0x06, 0x17, 0x00 // muls eq r7 r10 r6
};
const byte kInstruction_muls_pl_r1_r12_r2[] = {
  0x9c, 0x02, 0x11, 0x50 // muls pl r1 r12 r2
};
const byte kInstruction_muls_le_r14_r6_r6[] = {
  0x96, 0x06, 0x1e, 0xd0 // muls le r14 r6 r6
};
const byte kInstruction_muls_ne_r3_r8_r8[] = {
  0x98, 0x08, 0x13, 0x10 // muls ne r3 r8 r8
};
const byte kInstruction_muls_eq_r4_r12_r8[] = {
  0x9c, 0x08, 0x14, 0x00 // muls eq r4 r12 r8
};
const byte kInstruction_muls_ge_r11_r2_r3[] = {
  0x92, 0x03, 0x1b, 0xa0 // muls ge r11 r2 r3
};
const byte kInstruction_muls_hi_r12_r6_r11[] = {
  0x96, 0x0b, 0x1c, 0x80 // muls hi r12 r6 r11
};
const byte kInstruction_muls_cs_r4_r5_r10[] = {
  0x95, 0x0a, 0x14, 0x20 // muls cs r4 r5 r10
};
const byte kInstruction_muls_ge_r10_r2_r10[] = {
  0x92, 0x0a, 0x1a, 0xa0 // muls ge r10 r2 r10
};
const byte kInstruction_muls_ge_r5_r14_r6[] = {
  0x9e, 0x06, 0x15, 0xa0 // muls ge r5 r14 r6
};
const byte kInstruction_muls_gt_r13_r7_r5[] = {
  0x97, 0x05, 0x1d, 0xc0 // muls gt r13 r7 r5
};
const byte kInstruction_muls_ge_r13_r4_r12[] = {
  0x94, 0x0c, 0x1d, 0xa0 // muls ge r13 r4 r12
};
const byte kInstruction_muls_lt_r8_r10_r14[] = {
  0x9a, 0x0e, 0x18, 0xb0 // muls lt r8 r10 r14
};
const byte kInstruction_muls_le_r4_r3_r13[] = {
  0x93, 0x0d, 0x14, 0xd0 // muls le r4 r3 r13
};
const byte kInstruction_muls_pl_r0_r9_r0[] = {
  0x99, 0x00, 0x10, 0x50 // muls pl r0 r9 r0
};
const byte kInstruction_muls_eq_r2_r3_r1[] = {
  0x93, 0x01, 0x12, 0x00 // muls eq r2 r3 r1
};
const byte kInstruction_muls_vc_r0_r0_r3[] = {
  0x90, 0x03, 0x10, 0x70 // muls vc r0 r0 r3
};
const byte kInstruction_muls_mi_r10_r8_r11[] = {
  0x98, 0x0b, 0x1a, 0x40 // muls mi r10 r8 r11
};
const byte kInstruction_muls_mi_r5_r14_r14[] = {
  0x9e, 0x0e, 0x15, 0x40 // muls mi r5 r14 r14
};
const byte kInstruction_muls_gt_r5_r11_r2[] = {
  0x9b, 0x02, 0x15, 0xc0 // muls gt r5 r11 r2
};
const byte kInstruction_muls_al_r4_r7_r11[] = {
  0x97, 0x0b, 0x14, 0xe0 // muls al r4 r7 r11
};
const TestResult kReferencemuls[] = {
  {
    ARRAY_SIZE(kInstruction_muls_hi_r1_r9_r5),
    kInstruction_muls_hi_r1_r9_r5,
  },
  {
    ARRAY_SIZE(kInstruction_muls_pl_r8_r6_r2),
    kInstruction_muls_pl_r8_r6_r2,
  },
  {
    ARRAY_SIZE(kInstruction_muls_hi_r5_r8_r2),
    kInstruction_muls_hi_r5_r8_r2,
  },
  {
    ARRAY_SIZE(kInstruction_muls_vc_r9_r2_r7),
    kInstruction_muls_vc_r9_r2_r7,
  },
  {
    ARRAY_SIZE(kInstruction_muls_lt_r4_r6_r3),
    kInstruction_muls_lt_r4_r6_r3,
  },
  {
    ARRAY_SIZE(kInstruction_muls_le_r11_r6_r2),
    kInstruction_muls_le_r11_r6_r2,
  },
  {
    ARRAY_SIZE(kInstruction_muls_cc_r8_r14_r4),
    kInstruction_muls_cc_r8_r14_r4,
  },
  {
    ARRAY_SIZE(kInstruction_muls_le_r5_r14_r6),
    kInstruction_muls_le_r5_r14_r6,
  },
  {
    ARRAY_SIZE(kInstruction_muls_lt_r6_r1_r0),
    kInstruction_muls_lt_r6_r1_r0,
  },
  {
    ARRAY_SIZE(kInstruction_muls_lt_r5_r0_r9),
    kInstruction_muls_lt_r5_r0_r9,
  },
  {
    ARRAY_SIZE(kInstruction_muls_le_r8_r12_r7),
    kInstruction_muls_le_r8_r12_r7,
  },
  {
    ARRAY_SIZE(kInstruction_muls_eq_r7_r14_r6),
    kInstruction_muls_eq_r7_r14_r6,
  },
  {
    ARRAY_SIZE(kInstruction_muls_cs_r7_r4_r6),
    kInstruction_muls_cs_r7_r4_r6,
  },
  {
    ARRAY_SIZE(kInstruction_muls_gt_r9_r6_r9),
    kInstruction_muls_gt_r9_r6_r9,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ne_r13_r9_r1),
    kInstruction_muls_ne_r13_r9_r1,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ge_r13_r1_r13),
    kInstruction_muls_ge_r13_r1_r13,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ls_r8_r10_r2),
    kInstruction_muls_ls_r8_r10_r2,
  },
  {
    ARRAY_SIZE(kInstruction_muls_hi_r0_r13_r5),
    kInstruction_muls_hi_r0_r13_r5,
  },
  {
    ARRAY_SIZE(kInstruction_muls_pl_r13_r7_r8),
    kInstruction_muls_pl_r13_r7_r8,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ge_r4_r13_r11),
    kInstruction_muls_ge_r4_r13_r11,
  },
  {
    ARRAY_SIZE(kInstruction_muls_cs_r5_r10_r5),
    kInstruction_muls_cs_r5_r10_r5,
  },
  {
    ARRAY_SIZE(kInstruction_muls_cs_r5_r4_r3),
    kInstruction_muls_cs_r5_r4_r3,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ls_r6_r14_r8),
    kInstruction_muls_ls_r6_r14_r8,
  },
  {
    ARRAY_SIZE(kInstruction_muls_vs_r3_r8_r6),
    kInstruction_muls_vs_r3_r8_r6,
  },
  {
    ARRAY_SIZE(kInstruction_muls_vc_r7_r12_r3),
    kInstruction_muls_vc_r7_r12_r3,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ge_r1_r4_r1),
    kInstruction_muls_ge_r1_r4_r1,
  },
  {
    ARRAY_SIZE(kInstruction_muls_cc_r4_r7_r10),
    kInstruction_muls_cc_r4_r7_r10,
  },
  {
    ARRAY_SIZE(kInstruction_muls_cc_r2_r0_r13),
    kInstruction_muls_cc_r2_r0_r13,
  },
  {
    ARRAY_SIZE(kInstruction_muls_vs_r9_r6_r8),
    kInstruction_muls_vs_r9_r6_r8,
  },
  {
    ARRAY_SIZE(kInstruction_muls_cs_r14_r11_r13),
    kInstruction_muls_cs_r14_r11_r13,
  },
  {
    ARRAY_SIZE(kInstruction_muls_pl_r5_r8_r4),
    kInstruction_muls_pl_r5_r8_r4,
  },
  {
    ARRAY_SIZE(kInstruction_muls_pl_r2_r3_r7),
    kInstruction_muls_pl_r2_r3_r7,
  },
  {
    ARRAY_SIZE(kInstruction_muls_cs_r7_r12_r14),
    kInstruction_muls_cs_r7_r12_r14,
  },
  {
    ARRAY_SIZE(kInstruction_muls_hi_r6_r6_r1),
    kInstruction_muls_hi_r6_r6_r1,
  },
  {
    ARRAY_SIZE(kInstruction_muls_cc_r6_r9_r6),
    kInstruction_muls_cc_r6_r9_r6,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ne_r12_r12_r0),
    kInstruction_muls_ne_r12_r12_r0,
  },
  {
    ARRAY_SIZE(kInstruction_muls_cc_r9_r3_r8),
    kInstruction_muls_cc_r9_r3_r8,
  },
  {
    ARRAY_SIZE(kInstruction_muls_mi_r13_r6_r1),
    kInstruction_muls_mi_r13_r6_r1,
  },
  {
    ARRAY_SIZE(kInstruction_muls_lt_r4_r8_r6),
    kInstruction_muls_lt_r4_r8_r6,
  },
  {
    ARRAY_SIZE(kInstruction_muls_hi_r11_r5_r9),
    kInstruction_muls_hi_r11_r5_r9,
  },
  {
    ARRAY_SIZE(kInstruction_muls_cc_r6_r10_r6),
    kInstruction_muls_cc_r6_r10_r6,
  },
  {
    ARRAY_SIZE(kInstruction_muls_eq_r10_r10_r5),
    kInstruction_muls_eq_r10_r10_r5,
  },
  {
    ARRAY_SIZE(kInstruction_muls_al_r5_r4_r11),
    kInstruction_muls_al_r5_r4_r11,
  },
  {
    ARRAY_SIZE(kInstruction_muls_pl_r11_r11_r2),
    kInstruction_muls_pl_r11_r11_r2,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ls_r6_r14_r12),
    kInstruction_muls_ls_r6_r14_r12,
  },
  {
    ARRAY_SIZE(kInstruction_muls_vc_r7_r7_r2),
    kInstruction_muls_vc_r7_r7_r2,
  },
  {
    ARRAY_SIZE(kInstruction_muls_eq_r10_r8_r4),
    kInstruction_muls_eq_r10_r8_r4,
  },
  {
    ARRAY_SIZE(kInstruction_muls_al_r14_r7_r2),
    kInstruction_muls_al_r14_r7_r2,
  },
  {
    ARRAY_SIZE(kInstruction_muls_cs_r3_r11_r10),
    kInstruction_muls_cs_r3_r11_r10,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ls_r11_r4_r0),
    kInstruction_muls_ls_r11_r4_r0,
  },
  {
    ARRAY_SIZE(kInstruction_muls_hi_r11_r8_r9),
    kInstruction_muls_hi_r11_r8_r9,
  },
  {
    ARRAY_SIZE(kInstruction_muls_vs_r2_r14_r13),
    kInstruction_muls_vs_r2_r14_r13,
  },
  {
    ARRAY_SIZE(kInstruction_muls_al_r1_r13_r9),
    kInstruction_muls_al_r1_r13_r9,
  },
  {
    ARRAY_SIZE(kInstruction_muls_eq_r3_r9_r13),
    kInstruction_muls_eq_r3_r9_r13,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ge_r10_r3_r13),
    kInstruction_muls_ge_r10_r3_r13,
  },
  {
    ARRAY_SIZE(kInstruction_muls_pl_r8_r5_r10),
    kInstruction_muls_pl_r8_r5_r10,
  },
  {
    ARRAY_SIZE(kInstruction_muls_vc_r8_r11_r6),
    kInstruction_muls_vc_r8_r11_r6,
  },
  {
    ARRAY_SIZE(kInstruction_muls_eq_r0_r0_r5),
    kInstruction_muls_eq_r0_r0_r5,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ne_r6_r5_r8),
    kInstruction_muls_ne_r6_r5_r8,
  },
  {
    ARRAY_SIZE(kInstruction_muls_hi_r5_r13_r3),
    kInstruction_muls_hi_r5_r13_r3,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ne_r11_r14_r14),
    kInstruction_muls_ne_r11_r14_r14,
  },
  {
    ARRAY_SIZE(kInstruction_muls_mi_r1_r0_r6),
    kInstruction_muls_mi_r1_r0_r6,
  },
  {
    ARRAY_SIZE(kInstruction_muls_le_r14_r8_r2),
    kInstruction_muls_le_r14_r8_r2,
  },
  {
    ARRAY_SIZE(kInstruction_muls_eq_r9_r6_r5),
    kInstruction_muls_eq_r9_r6_r5,
  },
  {
    ARRAY_SIZE(kInstruction_muls_eq_r11_r0_r13),
    kInstruction_muls_eq_r11_r0_r13,
  },
  {
    ARRAY_SIZE(kInstruction_muls_pl_r4_r5_r14),
    kInstruction_muls_pl_r4_r5_r14,
  },
  {
    ARRAY_SIZE(kInstruction_muls_cs_r13_r5_r13),
    kInstruction_muls_cs_r13_r5_r13,
  },
  {
    ARRAY_SIZE(kInstruction_muls_mi_r0_r13_r8),
    kInstruction_muls_mi_r0_r13_r8,
  },
  {
    ARRAY_SIZE(kInstruction_muls_lt_r2_r13_r3),
    kInstruction_muls_lt_r2_r13_r3,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ls_r8_r1_r11),
    kInstruction_muls_ls_r8_r1_r11,
  },
  {
    ARRAY_SIZE(kInstruction_muls_vc_r14_r11_r8),
    kInstruction_muls_vc_r14_r11_r8,
  },
  {
    ARRAY_SIZE(kInstruction_muls_lt_r4_r13_r12),
    kInstruction_muls_lt_r4_r13_r12,
  },
  {
    ARRAY_SIZE(kInstruction_muls_eq_r2_r1_r14),
    kInstruction_muls_eq_r2_r1_r14,
  },
  {
    ARRAY_SIZE(kInstruction_muls_eq_r9_r4_r14),
    kInstruction_muls_eq_r9_r4_r14,
  },
  {
    ARRAY_SIZE(kInstruction_muls_hi_r10_r6_r13),
    kInstruction_muls_hi_r10_r6_r13,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ge_r12_r9_r4),
    kInstruction_muls_ge_r12_r9_r4,
  },
  {
    ARRAY_SIZE(kInstruction_muls_le_r9_r11_r14),
    kInstruction_muls_le_r9_r11_r14,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ls_r0_r9_r5),
    kInstruction_muls_ls_r0_r9_r5,
  },
  {
    ARRAY_SIZE(kInstruction_muls_mi_r2_r3_r8),
    kInstruction_muls_mi_r2_r3_r8,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ne_r14_r10_r14),
    kInstruction_muls_ne_r14_r10_r14,
  },
  {
    ARRAY_SIZE(kInstruction_muls_eq_r6_r2_r10),
    kInstruction_muls_eq_r6_r2_r10,
  },
  {
    ARRAY_SIZE(kInstruction_muls_lt_r11_r0_r12),
    kInstruction_muls_lt_r11_r0_r12,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ne_r1_r12_r10),
    kInstruction_muls_ne_r1_r12_r10,
  },
  {
    ARRAY_SIZE(kInstruction_muls_cc_r1_r0_r2),
    kInstruction_muls_cc_r1_r0_r2,
  },
  {
    ARRAY_SIZE(kInstruction_muls_al_r5_r5_r7),
    kInstruction_muls_al_r5_r5_r7,
  },
  {
    ARRAY_SIZE(kInstruction_muls_hi_r7_r13_r1),
    kInstruction_muls_hi_r7_r13_r1,
  },
  {
    ARRAY_SIZE(kInstruction_muls_cs_r4_r4_r9),
    kInstruction_muls_cs_r4_r4_r9,
  },
  {
    ARRAY_SIZE(kInstruction_muls_eq_r14_r4_r14),
    kInstruction_muls_eq_r14_r4_r14,
  },
  {
    ARRAY_SIZE(kInstruction_muls_vs_r10_r5_r14),
    kInstruction_muls_vs_r10_r5_r14,
  },
  {
    ARRAY_SIZE(kInstruction_muls_gt_r4_r3_r11),
    kInstruction_muls_gt_r4_r3_r11,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ne_r14_r10_r12),
    kInstruction_muls_ne_r14_r10_r12,
  },
  {
    ARRAY_SIZE(kInstruction_muls_vs_r2_r11_r0),
    kInstruction_muls_vs_r2_r11_r0,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ge_r5_r12_r7),
    kInstruction_muls_ge_r5_r12_r7,
  },
  {
    ARRAY_SIZE(kInstruction_muls_mi_r7_r14_r6),
    kInstruction_muls_mi_r7_r14_r6,
  },
  {
    ARRAY_SIZE(kInstruction_muls_gt_r8_r3_r8),
    kInstruction_muls_gt_r8_r3_r8,
  },
  {
    ARRAY_SIZE(kInstruction_muls_hi_r9_r14_r3),
    kInstruction_muls_hi_r9_r14_r3,
  },
  {
    ARRAY_SIZE(kInstruction_muls_vc_r2_r11_r2),
    kInstruction_muls_vc_r2_r11_r2,
  },
  {
    ARRAY_SIZE(kInstruction_muls_hi_r11_r7_r12),
    kInstruction_muls_hi_r11_r7_r12,
  },
  {
    ARRAY_SIZE(kInstruction_muls_cs_r6_r4_r11),
    kInstruction_muls_cs_r6_r4_r11,
  },
  {
    ARRAY_SIZE(kInstruction_muls_cs_r12_r5_r9),
    kInstruction_muls_cs_r12_r5_r9,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ls_r5_r10_r5),
    kInstruction_muls_ls_r5_r10_r5,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ls_r0_r9_r13),
    kInstruction_muls_ls_r0_r9_r13,
  },
  {
    ARRAY_SIZE(kInstruction_muls_lt_r3_r3_r5),
    kInstruction_muls_lt_r3_r3_r5,
  },
  {
    ARRAY_SIZE(kInstruction_muls_mi_r0_r12_r8),
    kInstruction_muls_mi_r0_r12_r8,
  },
  {
    ARRAY_SIZE(kInstruction_muls_pl_r3_r12_r12),
    kInstruction_muls_pl_r3_r12_r12,
  },
  {
    ARRAY_SIZE(kInstruction_muls_eq_r8_r12_r5),
    kInstruction_muls_eq_r8_r12_r5,
  },
  {
    ARRAY_SIZE(kInstruction_muls_cc_r7_r8_r1),
    kInstruction_muls_cc_r7_r8_r1,
  },
  {
    ARRAY_SIZE(kInstruction_muls_hi_r2_r13_r10),
    kInstruction_muls_hi_r2_r13_r10,
  },
  {
    ARRAY_SIZE(kInstruction_muls_al_r7_r10_r10),
    kInstruction_muls_al_r7_r10_r10,
  },
  {
    ARRAY_SIZE(kInstruction_muls_vc_r1_r12_r2),
    kInstruction_muls_vc_r1_r12_r2,
  },
  {
    ARRAY_SIZE(kInstruction_muls_cc_r8_r5_r8),
    kInstruction_muls_cc_r8_r5_r8,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ls_r3_r7_r9),
    kInstruction_muls_ls_r3_r7_r9,
  },
  {
    ARRAY_SIZE(kInstruction_muls_al_r8_r10_r8),
    kInstruction_muls_al_r8_r10_r8,
  },
  {
    ARRAY_SIZE(kInstruction_muls_lt_r4_r12_r10),
    kInstruction_muls_lt_r4_r12_r10,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ge_r10_r5_r11),
    kInstruction_muls_ge_r10_r5_r11,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ls_r3_r14_r4),
    kInstruction_muls_ls_r3_r14_r4,
  },
  {
    ARRAY_SIZE(kInstruction_muls_hi_r3_r6_r12),
    kInstruction_muls_hi_r3_r6_r12,
  },
  {
    ARRAY_SIZE(kInstruction_muls_hi_r6_r0_r4),
    kInstruction_muls_hi_r6_r0_r4,
  },
  {
    ARRAY_SIZE(kInstruction_muls_al_r11_r6_r0),
    kInstruction_muls_al_r11_r6_r0,
  },
  {
    ARRAY_SIZE(kInstruction_muls_mi_r3_r1_r9),
    kInstruction_muls_mi_r3_r1_r9,
  },
  {
    ARRAY_SIZE(kInstruction_muls_mi_r12_r13_r0),
    kInstruction_muls_mi_r12_r13_r0,
  },
  {
    ARRAY_SIZE(kInstruction_muls_le_r1_r2_r5),
    kInstruction_muls_le_r1_r2_r5,
  },
  {
    ARRAY_SIZE(kInstruction_muls_hi_r4_r3_r14),
    kInstruction_muls_hi_r4_r3_r14,
  },
  {
    ARRAY_SIZE(kInstruction_muls_eq_r6_r11_r11),
    kInstruction_muls_eq_r6_r11_r11,
  },
  {
    ARRAY_SIZE(kInstruction_muls_cc_r14_r11_r14),
    kInstruction_muls_cc_r14_r11_r14,
  },
  {
    ARRAY_SIZE(kInstruction_muls_hi_r4_r10_r0),
    kInstruction_muls_hi_r4_r10_r0,
  },
  {
    ARRAY_SIZE(kInstruction_muls_cc_r7_r11_r1),
    kInstruction_muls_cc_r7_r11_r1,
  },
  {
    ARRAY_SIZE(kInstruction_muls_mi_r14_r6_r10),
    kInstruction_muls_mi_r14_r6_r10,
  },
  {
    ARRAY_SIZE(kInstruction_muls_eq_r2_r0_r11),
    kInstruction_muls_eq_r2_r0_r11,
  },
  {
    ARRAY_SIZE(kInstruction_muls_mi_r13_r5_r12),
    kInstruction_muls_mi_r13_r5_r12,
  },
  {
    ARRAY_SIZE(kInstruction_muls_eq_r2_r12_r5),
    kInstruction_muls_eq_r2_r12_r5,
  },
  {
    ARRAY_SIZE(kInstruction_muls_le_r12_r0_r2),
    kInstruction_muls_le_r12_r0_r2,
  },
  {
    ARRAY_SIZE(kInstruction_muls_vc_r10_r10_r9),
    kInstruction_muls_vc_r10_r10_r9,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ls_r11_r11_r8),
    kInstruction_muls_ls_r11_r11_r8,
  },
  {
    ARRAY_SIZE(kInstruction_muls_hi_r10_r11_r9),
    kInstruction_muls_hi_r10_r11_r9,
  },
  {
    ARRAY_SIZE(kInstruction_muls_vs_r7_r12_r14),
    kInstruction_muls_vs_r7_r12_r14,
  },
  {
    ARRAY_SIZE(kInstruction_muls_gt_r11_r14_r12),
    kInstruction_muls_gt_r11_r14_r12,
  },
  {
    ARRAY_SIZE(kInstruction_muls_vs_r0_r12_r8),
    kInstruction_muls_vs_r0_r12_r8,
  },
  {
    ARRAY_SIZE(kInstruction_muls_al_r0_r5_r7),
    kInstruction_muls_al_r0_r5_r7,
  },
  {
    ARRAY_SIZE(kInstruction_muls_hi_r5_r13_r8),
    kInstruction_muls_hi_r5_r13_r8,
  },
  {
    ARRAY_SIZE(kInstruction_muls_le_r9_r9_r7),
    kInstruction_muls_le_r9_r9_r7,
  },
  {
    ARRAY_SIZE(kInstruction_muls_cc_r4_r9_r5),
    kInstruction_muls_cc_r4_r9_r5,
  },
  {
    ARRAY_SIZE(kInstruction_muls_vs_r8_r1_r3),
    kInstruction_muls_vs_r8_r1_r3,
  },
  {
    ARRAY_SIZE(kInstruction_muls_cc_r0_r10_r12),
    kInstruction_muls_cc_r0_r10_r12,
  },
  {
    ARRAY_SIZE(kInstruction_muls_eq_r7_r14_r0),
    kInstruction_muls_eq_r7_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_muls_vs_r12_r9_r11),
    kInstruction_muls_vs_r12_r9_r11,
  },
  {
    ARRAY_SIZE(kInstruction_muls_gt_r5_r9_r11),
    kInstruction_muls_gt_r5_r9_r11,
  },
  {
    ARRAY_SIZE(kInstruction_muls_cs_r14_r13_r7),
    kInstruction_muls_cs_r14_r13_r7,
  },
  {
    ARRAY_SIZE(kInstruction_muls_mi_r11_r3_r10),
    kInstruction_muls_mi_r11_r3_r10,
  },
  {
    ARRAY_SIZE(kInstruction_muls_hi_r11_r8_r12),
    kInstruction_muls_hi_r11_r8_r12,
  },
  {
    ARRAY_SIZE(kInstruction_muls_cs_r3_r8_r13),
    kInstruction_muls_cs_r3_r8_r13,
  },
  {
    ARRAY_SIZE(kInstruction_muls_pl_r10_r12_r6),
    kInstruction_muls_pl_r10_r12_r6,
  },
  {
    ARRAY_SIZE(kInstruction_muls_vc_r7_r3_r2),
    kInstruction_muls_vc_r7_r3_r2,
  },
  {
    ARRAY_SIZE(kInstruction_muls_mi_r9_r0_r8),
    kInstruction_muls_mi_r9_r0_r8,
  },
  {
    ARRAY_SIZE(kInstruction_muls_eq_r2_r13_r7),
    kInstruction_muls_eq_r2_r13_r7,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ne_r2_r14_r0),
    kInstruction_muls_ne_r2_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_muls_vs_r4_r10_r0),
    kInstruction_muls_vs_r4_r10_r0,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ls_r0_r2_r2),
    kInstruction_muls_ls_r0_r2_r2,
  },
  {
    ARRAY_SIZE(kInstruction_muls_cc_r1_r6_r0),
    kInstruction_muls_cc_r1_r6_r0,
  },
  {
    ARRAY_SIZE(kInstruction_muls_lt_r12_r0_r8),
    kInstruction_muls_lt_r12_r0_r8,
  },
  {
    ARRAY_SIZE(kInstruction_muls_cc_r9_r3_r14),
    kInstruction_muls_cc_r9_r3_r14,
  },
  {
    ARRAY_SIZE(kInstruction_muls_vs_r7_r9_r1),
    kInstruction_muls_vs_r7_r9_r1,
  },
  {
    ARRAY_SIZE(kInstruction_muls_eq_r11_r9_r14),
    kInstruction_muls_eq_r11_r9_r14,
  },
  {
    ARRAY_SIZE(kInstruction_muls_pl_r6_r10_r4),
    kInstruction_muls_pl_r6_r10_r4,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ne_r8_r5_r6),
    kInstruction_muls_ne_r8_r5_r6,
  },
  {
    ARRAY_SIZE(kInstruction_muls_cs_r0_r6_r2),
    kInstruction_muls_cs_r0_r6_r2,
  },
  {
    ARRAY_SIZE(kInstruction_muls_eq_r11_r12_r4),
    kInstruction_muls_eq_r11_r12_r4,
  },
  {
    ARRAY_SIZE(kInstruction_muls_lt_r14_r3_r14),
    kInstruction_muls_lt_r14_r3_r14,
  },
  {
    ARRAY_SIZE(kInstruction_muls_le_r7_r12_r14),
    kInstruction_muls_le_r7_r12_r14,
  },
  {
    ARRAY_SIZE(kInstruction_muls_hi_r2_r9_r9),
    kInstruction_muls_hi_r2_r9_r9,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ne_r8_r1_r0),
    kInstruction_muls_ne_r8_r1_r0,
  },
  {
    ARRAY_SIZE(kInstruction_muls_cc_r5_r11_r2),
    kInstruction_muls_cc_r5_r11_r2,
  },
  {
    ARRAY_SIZE(kInstruction_muls_hi_r0_r1_r2),
    kInstruction_muls_hi_r0_r1_r2,
  },
  {
    ARRAY_SIZE(kInstruction_muls_al_r4_r9_r4),
    kInstruction_muls_al_r4_r9_r4,
  },
  {
    ARRAY_SIZE(kInstruction_muls_cs_r12_r7_r14),
    kInstruction_muls_cs_r12_r7_r14,
  },
  {
    ARRAY_SIZE(kInstruction_muls_cc_r4_r12_r10),
    kInstruction_muls_cc_r4_r12_r10,
  },
  {
    ARRAY_SIZE(kInstruction_muls_al_r3_r5_r10),
    kInstruction_muls_al_r3_r5_r10,
  },
  {
    ARRAY_SIZE(kInstruction_muls_mi_r5_r3_r7),
    kInstruction_muls_mi_r5_r3_r7,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ls_r10_r6_r2),
    kInstruction_muls_ls_r10_r6_r2,
  },
  {
    ARRAY_SIZE(kInstruction_muls_mi_r0_r12_r11),
    kInstruction_muls_mi_r0_r12_r11,
  },
  {
    ARRAY_SIZE(kInstruction_muls_vc_r12_r5_r6),
    kInstruction_muls_vc_r12_r5_r6,
  },
  {
    ARRAY_SIZE(kInstruction_muls_cs_r3_r9_r4),
    kInstruction_muls_cs_r3_r9_r4,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ls_r4_r9_r11),
    kInstruction_muls_ls_r4_r9_r11,
  },
  {
    ARRAY_SIZE(kInstruction_muls_le_r14_r8_r13),
    kInstruction_muls_le_r14_r8_r13,
  },
  {
    ARRAY_SIZE(kInstruction_muls_gt_r4_r10_r8),
    kInstruction_muls_gt_r4_r10_r8,
  },
  {
    ARRAY_SIZE(kInstruction_muls_al_r6_r9_r9),
    kInstruction_muls_al_r6_r9_r9,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ne_r8_r5_r12),
    kInstruction_muls_ne_r8_r5_r12,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ne_r0_r4_r8),
    kInstruction_muls_ne_r0_r4_r8,
  },
  {
    ARRAY_SIZE(kInstruction_muls_mi_r7_r13_r3),
    kInstruction_muls_mi_r7_r13_r3,
  },
  {
    ARRAY_SIZE(kInstruction_muls_cc_r11_r7_r0),
    kInstruction_muls_cc_r11_r7_r0,
  },
  {
    ARRAY_SIZE(kInstruction_muls_hi_r1_r0_r12),
    kInstruction_muls_hi_r1_r0_r12,
  },
  {
    ARRAY_SIZE(kInstruction_muls_lt_r8_r9_r3),
    kInstruction_muls_lt_r8_r9_r3,
  },
  {
    ARRAY_SIZE(kInstruction_muls_al_r0_r2_r1),
    kInstruction_muls_al_r0_r2_r1,
  },
  {
    ARRAY_SIZE(kInstruction_muls_vs_r4_r3_r14),
    kInstruction_muls_vs_r4_r3_r14,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ge_r2_r11_r1),
    kInstruction_muls_ge_r2_r11_r1,
  },
  {
    ARRAY_SIZE(kInstruction_muls_lt_r12_r9_r6),
    kInstruction_muls_lt_r12_r9_r6,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ls_r8_r2_r7),
    kInstruction_muls_ls_r8_r2_r7,
  },
  {
    ARRAY_SIZE(kInstruction_muls_le_r8_r13_r3),
    kInstruction_muls_le_r8_r13_r3,
  },
  {
    ARRAY_SIZE(kInstruction_muls_eq_r11_r13_r14),
    kInstruction_muls_eq_r11_r13_r14,
  },
  {
    ARRAY_SIZE(kInstruction_muls_lt_r1_r6_r13),
    kInstruction_muls_lt_r1_r6_r13,
  },
  {
    ARRAY_SIZE(kInstruction_muls_cs_r3_r8_r11),
    kInstruction_muls_cs_r3_r8_r11,
  },
  {
    ARRAY_SIZE(kInstruction_muls_pl_r12_r5_r4),
    kInstruction_muls_pl_r12_r5_r4,
  },
  {
    ARRAY_SIZE(kInstruction_muls_eq_r8_r7_r2),
    kInstruction_muls_eq_r8_r7_r2,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ls_r2_r12_r2),
    kInstruction_muls_ls_r2_r12_r2,
  },
  {
    ARRAY_SIZE(kInstruction_muls_le_r14_r2_r3),
    kInstruction_muls_le_r14_r2_r3,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ge_r10_r11_r6),
    kInstruction_muls_ge_r10_r11_r6,
  },
  {
    ARRAY_SIZE(kInstruction_muls_hi_r0_r2_r2),
    kInstruction_muls_hi_r0_r2_r2,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ge_r2_r0_r2),
    kInstruction_muls_ge_r2_r0_r2,
  },
  {
    ARRAY_SIZE(kInstruction_muls_vs_r11_r14_r0),
    kInstruction_muls_vs_r11_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_muls_lt_r2_r0_r1),
    kInstruction_muls_lt_r2_r0_r1,
  },
  {
    ARRAY_SIZE(kInstruction_muls_cs_r2_r5_r11),
    kInstruction_muls_cs_r2_r5_r11,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ls_r7_r14_r5),
    kInstruction_muls_ls_r7_r14_r5,
  },
  {
    ARRAY_SIZE(kInstruction_muls_pl_r0_r0_r3),
    kInstruction_muls_pl_r0_r0_r3,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ge_r6_r8_r8),
    kInstruction_muls_ge_r6_r8_r8,
  },
  {
    ARRAY_SIZE(kInstruction_muls_le_r11_r1_r10),
    kInstruction_muls_le_r11_r1_r10,
  },
  {
    ARRAY_SIZE(kInstruction_muls_vs_r5_r2_r7),
    kInstruction_muls_vs_r5_r2_r7,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ne_r4_r4_r8),
    kInstruction_muls_ne_r4_r4_r8,
  },
  {
    ARRAY_SIZE(kInstruction_muls_cc_r9_r14_r13),
    kInstruction_muls_cc_r9_r14_r13,
  },
  {
    ARRAY_SIZE(kInstruction_muls_hi_r14_r6_r3),
    kInstruction_muls_hi_r14_r6_r3,
  },
  {
    ARRAY_SIZE(kInstruction_muls_al_r0_r8_r0),
    kInstruction_muls_al_r0_r8_r0,
  },
  {
    ARRAY_SIZE(kInstruction_muls_lt_r6_r11_r1),
    kInstruction_muls_lt_r6_r11_r1,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ge_r7_r6_r12),
    kInstruction_muls_ge_r7_r6_r12,
  },
  {
    ARRAY_SIZE(kInstruction_muls_cs_r4_r6_r14),
    kInstruction_muls_cs_r4_r6_r14,
  },
  {
    ARRAY_SIZE(kInstruction_muls_cs_r7_r6_r7),
    kInstruction_muls_cs_r7_r6_r7,
  },
  {
    ARRAY_SIZE(kInstruction_muls_cs_r3_r7_r10),
    kInstruction_muls_cs_r3_r7_r10,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ne_r0_r2_r1),
    kInstruction_muls_ne_r0_r2_r1,
  },
  {
    ARRAY_SIZE(kInstruction_muls_vs_r9_r10_r13),
    kInstruction_muls_vs_r9_r10_r13,
  },
  {
    ARRAY_SIZE(kInstruction_muls_vc_r11_r14_r12),
    kInstruction_muls_vc_r11_r14_r12,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ge_r14_r8_r7),
    kInstruction_muls_ge_r14_r8_r7,
  },
  {
    ARRAY_SIZE(kInstruction_muls_lt_r13_r0_r11),
    kInstruction_muls_lt_r13_r0_r11,
  },
  {
    ARRAY_SIZE(kInstruction_muls_lt_r14_r13_r4),
    kInstruction_muls_lt_r14_r13_r4,
  },
  {
    ARRAY_SIZE(kInstruction_muls_al_r1_r10_r9),
    kInstruction_muls_al_r1_r10_r9,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ge_r11_r14_r11),
    kInstruction_muls_ge_r11_r14_r11,
  },
  {
    ARRAY_SIZE(kInstruction_muls_cs_r11_r4_r11),
    kInstruction_muls_cs_r11_r4_r11,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ge_r0_r14_r7),
    kInstruction_muls_ge_r0_r14_r7,
  },
  {
    ARRAY_SIZE(kInstruction_muls_mi_r1_r2_r9),
    kInstruction_muls_mi_r1_r2_r9,
  },
  {
    ARRAY_SIZE(kInstruction_muls_eq_r5_r12_r3),
    kInstruction_muls_eq_r5_r12_r3,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ge_r1_r5_r12),
    kInstruction_muls_ge_r1_r5_r12,
  },
  {
    ARRAY_SIZE(kInstruction_muls_lt_r10_r11_r4),
    kInstruction_muls_lt_r10_r11_r4,
  },
  {
    ARRAY_SIZE(kInstruction_muls_le_r1_r1_r5),
    kInstruction_muls_le_r1_r1_r5,
  },
  {
    ARRAY_SIZE(kInstruction_muls_al_r9_r1_r8),
    kInstruction_muls_al_r9_r1_r8,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ne_r6_r8_r4),
    kInstruction_muls_ne_r6_r8_r4,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ge_r12_r2_r9),
    kInstruction_muls_ge_r12_r2_r9,
  },
  {
    ARRAY_SIZE(kInstruction_muls_pl_r4_r3_r10),
    kInstruction_muls_pl_r4_r3_r10,
  },
  {
    ARRAY_SIZE(kInstruction_muls_eq_r14_r4_r11),
    kInstruction_muls_eq_r14_r4_r11,
  },
  {
    ARRAY_SIZE(kInstruction_muls_cc_r9_r7_r6),
    kInstruction_muls_cc_r9_r7_r6,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ge_r12_r4_r5),
    kInstruction_muls_ge_r12_r4_r5,
  },
  {
    ARRAY_SIZE(kInstruction_muls_hi_r2_r3_r4),
    kInstruction_muls_hi_r2_r3_r4,
  },
  {
    ARRAY_SIZE(kInstruction_muls_cs_r0_r3_r1),
    kInstruction_muls_cs_r0_r3_r1,
  },
  {
    ARRAY_SIZE(kInstruction_muls_hi_r6_r2_r8),
    kInstruction_muls_hi_r6_r2_r8,
  },
  {
    ARRAY_SIZE(kInstruction_muls_cc_r3_r14_r13),
    kInstruction_muls_cc_r3_r14_r13,
  },
  {
    ARRAY_SIZE(kInstruction_muls_gt_r11_r4_r7),
    kInstruction_muls_gt_r11_r4_r7,
  },
  {
    ARRAY_SIZE(kInstruction_muls_hi_r5_r0_r12),
    kInstruction_muls_hi_r5_r0_r12,
  },
  {
    ARRAY_SIZE(kInstruction_muls_gt_r0_r14_r14),
    kInstruction_muls_gt_r0_r14_r14,
  },
  {
    ARRAY_SIZE(kInstruction_muls_hi_r9_r0_r10),
    kInstruction_muls_hi_r9_r0_r10,
  },
  {
    ARRAY_SIZE(kInstruction_muls_vc_r7_r11_r8),
    kInstruction_muls_vc_r7_r11_r8,
  },
  {
    ARRAY_SIZE(kInstruction_muls_pl_r11_r9_r6),
    kInstruction_muls_pl_r11_r9_r6,
  },
  {
    ARRAY_SIZE(kInstruction_muls_al_r3_r3_r7),
    kInstruction_muls_al_r3_r3_r7,
  },
  {
    ARRAY_SIZE(kInstruction_muls_mi_r5_r7_r9),
    kInstruction_muls_mi_r5_r7_r9,
  },
  {
    ARRAY_SIZE(kInstruction_muls_cc_r11_r2_r4),
    kInstruction_muls_cc_r11_r2_r4,
  },
  {
    ARRAY_SIZE(kInstruction_muls_cc_r9_r13_r10),
    kInstruction_muls_cc_r9_r13_r10,
  },
  {
    ARRAY_SIZE(kInstruction_muls_al_r5_r2_r6),
    kInstruction_muls_al_r5_r2_r6,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ge_r9_r4_r6),
    kInstruction_muls_ge_r9_r4_r6,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ls_r3_r3_r4),
    kInstruction_muls_ls_r3_r3_r4,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ge_r14_r1_r8),
    kInstruction_muls_ge_r14_r1_r8,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ls_r7_r12_r7),
    kInstruction_muls_ls_r7_r12_r7,
  },
  {
    ARRAY_SIZE(kInstruction_muls_al_r11_r10_r5),
    kInstruction_muls_al_r11_r10_r5,
  },
  {
    ARRAY_SIZE(kInstruction_muls_al_r7_r4_r6),
    kInstruction_muls_al_r7_r4_r6,
  },
  {
    ARRAY_SIZE(kInstruction_muls_vs_r12_r4_r10),
    kInstruction_muls_vs_r12_r4_r10,
  },
  {
    ARRAY_SIZE(kInstruction_muls_eq_r4_r4_r4),
    kInstruction_muls_eq_r4_r4_r4,
  },
  {
    ARRAY_SIZE(kInstruction_muls_vs_r6_r6_r12),
    kInstruction_muls_vs_r6_r6_r12,
  },
  {
    ARRAY_SIZE(kInstruction_muls_pl_r9_r3_r5),
    kInstruction_muls_pl_r9_r3_r5,
  },
  {
    ARRAY_SIZE(kInstruction_muls_eq_r6_r5_r13),
    kInstruction_muls_eq_r6_r5_r13,
  },
  {
    ARRAY_SIZE(kInstruction_muls_cc_r8_r2_r12),
    kInstruction_muls_cc_r8_r2_r12,
  },
  {
    ARRAY_SIZE(kInstruction_muls_le_r4_r2_r0),
    kInstruction_muls_le_r4_r2_r0,
  },
  {
    ARRAY_SIZE(kInstruction_muls_lt_r7_r9_r8),
    kInstruction_muls_lt_r7_r9_r8,
  },
  {
    ARRAY_SIZE(kInstruction_muls_le_r4_r7_r11),
    kInstruction_muls_le_r4_r7_r11,
  },
  {
    ARRAY_SIZE(kInstruction_muls_eq_r5_r7_r5),
    kInstruction_muls_eq_r5_r7_r5,
  },
  {
    ARRAY_SIZE(kInstruction_muls_vc_r10_r7_r12),
    kInstruction_muls_vc_r10_r7_r12,
  },
  {
    ARRAY_SIZE(kInstruction_muls_eq_r7_r10_r6),
    kInstruction_muls_eq_r7_r10_r6,
  },
  {
    ARRAY_SIZE(kInstruction_muls_pl_r1_r12_r2),
    kInstruction_muls_pl_r1_r12_r2,
  },
  {
    ARRAY_SIZE(kInstruction_muls_le_r14_r6_r6),
    kInstruction_muls_le_r14_r6_r6,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ne_r3_r8_r8),
    kInstruction_muls_ne_r3_r8_r8,
  },
  {
    ARRAY_SIZE(kInstruction_muls_eq_r4_r12_r8),
    kInstruction_muls_eq_r4_r12_r8,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ge_r11_r2_r3),
    kInstruction_muls_ge_r11_r2_r3,
  },
  {
    ARRAY_SIZE(kInstruction_muls_hi_r12_r6_r11),
    kInstruction_muls_hi_r12_r6_r11,
  },
  {
    ARRAY_SIZE(kInstruction_muls_cs_r4_r5_r10),
    kInstruction_muls_cs_r4_r5_r10,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ge_r10_r2_r10),
    kInstruction_muls_ge_r10_r2_r10,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ge_r5_r14_r6),
    kInstruction_muls_ge_r5_r14_r6,
  },
  {
    ARRAY_SIZE(kInstruction_muls_gt_r13_r7_r5),
    kInstruction_muls_gt_r13_r7_r5,
  },
  {
    ARRAY_SIZE(kInstruction_muls_ge_r13_r4_r12),
    kInstruction_muls_ge_r13_r4_r12,
  },
  {
    ARRAY_SIZE(kInstruction_muls_lt_r8_r10_r14),
    kInstruction_muls_lt_r8_r10_r14,
  },
  {
    ARRAY_SIZE(kInstruction_muls_le_r4_r3_r13),
    kInstruction_muls_le_r4_r3_r13,
  },
  {
    ARRAY_SIZE(kInstruction_muls_pl_r0_r9_r0),
    kInstruction_muls_pl_r0_r9_r0,
  },
  {
    ARRAY_SIZE(kInstruction_muls_eq_r2_r3_r1),
    kInstruction_muls_eq_r2_r3_r1,
  },
  {
    ARRAY_SIZE(kInstruction_muls_vc_r0_r0_r3),
    kInstruction_muls_vc_r0_r0_r3,
  },
  {
    ARRAY_SIZE(kInstruction_muls_mi_r10_r8_r11),
    kInstruction_muls_mi_r10_r8_r11,
  },
  {
    ARRAY_SIZE(kInstruction_muls_mi_r5_r14_r14),
    kInstruction_muls_mi_r5_r14_r14,
  },
  {
    ARRAY_SIZE(kInstruction_muls_gt_r5_r11_r2),
    kInstruction_muls_gt_r5_r11_r2,
  },
  {
    ARRAY_SIZE(kInstruction_muls_al_r4_r7_r11),
    kInstruction_muls_al_r4_r7_r11,
  },
};

#endif  // VIXL_ASSEMBLER_COND_RD_RN_RM_MULS_A32_H_
