/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef PASSWORDLABEL_H
#define PASSWORDLABEL_H
#include <QLabel>
#include <QLineEdit>
#include <QPaintEvent>
#include <QHBoxLayout>
#include <QPushButton>

#include "libukcc_global.h"

class LIBUKCC_EXPORT EyeBtn: public QLabel
{
    Q_OBJECT
public:
    EyeBtn(QWidget *parent = nullptr);
    ~EyeBtn();
    void setIconStatus(bool isHidden);
protected:
    void mousePressEvent(QMouseEvent * event);
    void mouseReleaseEvent(QMouseEvent *event);
private:
    bool mIsHidden = true;

Q_SIGNALS:
    void clicked(bool isHidden);
};

class LIBUKCC_EXPORT PasswordLabel : public QWidget
{
    Q_OBJECT
public:
    PasswordLabel(QWidget *parent = nullptr);
    ~PasswordLabel();

    void setStatus(bool isPassword);
    void setText(const QString &);
    QString text() const;

protected:
    void paintEvent(QPaintEvent *event);

private:
    QLineEdit *mPassword;
    EyeBtn *mEyesBtn;
};

#endif // PASSWORDLABEL_H
