/* Copyright (C) 2006,2007 Daiki Ueno <ueno@unixuser.org>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA */

#include <stdlib.h>
#include "heap.h"

long
heap_insert (heap_t heap, heap_entry_t entry)
{
  long i, j;
  if (heap->len == heap->cap)
    {
      heap->cap *= 2;
      heap->array = realloc (heap->array, heap->cap * sizeof(heap_entry_t));
      if (!heap->array)
	return -1;
    }
  heap->array[heap->len++] = entry;
  for (i = heap->len - 1, j = (i - 1) / 2;
       i > 0 && heap->array[i]->rank < heap->array[j]->rank;
       i = j, j = i / 2)
  {
    heap_entry_t t = heap->array[i];
    heap->array[i] = heap->array[j];
    heap->array[j] = t;
  }
  return heap->len;
}

heap_entry_t
heap_delete (heap_t heap)
{
  heap_entry_t root = heap->array[0];
  long i, j;
  if (heap->len == 0)
    return NULL;
  heap->array[0] = heap->array[--heap->len];
  for (i = 0, j = i * 2 + 1;
       j < heap->len && (heap->array[i]->rank >= heap->array[j]->rank ||
			 heap->array[i]->rank >= heap->array[j + 1]->rank);
       i = j, j = i * 2 + 1)
    {
      heap_entry_t t = heap->array[i];
      if (heap->array[j]->rank > heap->array[j + 1]->rank)
	j++;
      heap->array[i] = heap->array[j];
      heap->array[j] = t;
    }
  return root;
}

heap_t
heap_new (long cap)
{
  heap_t heap = malloc (sizeof(struct heap));
  heap->len = 0;
  heap->cap = cap;
  heap->array = malloc (heap->cap * sizeof(heap_entry_t));
  return heap;
}

void
heap_free (heap_t heap)
{
  free (heap->array);
  free (heap);
}
