// This file is part of ICU4X. For terms of use, please see the file
// called LICENSE at the top level of the ICU4X source tree
// (online at: https://github.com/unicode-org/icu4x/blob/main/LICENSE ).

// @generated by tools/make/codegen/src/capi_datetime.rs

#[rustfmt::skip]
#[diplomat::bridge]
#[diplomat::abi_rename = "icu4x_{0}_mv1"]
#[diplomat::attr(auto, namespace = "icu4x")]
pub mod ffi {
    use alloc::boxed::Box;
    use icu_calendar::Gregorian;
    use writeable::TryWriteable;

    #[allow(unused_imports)]
    use crate::datetime_helpers::{self, map_or_default};

    #[allow(unused_imports)]
    use crate::unstable::{
        date_formatter::ffi::{DateFormatter, DateFormatterGregorian},
        date_time_formatter::ffi::{DateTimeFormatter, DateTimeFormatterGregorian},
        date::ffi::IsoDate,
        datetime_options::ffi::{DateTimeAlignment, DateTimeLength, TimePrecision},
        errors::ffi::DateTimeFormatterLoadError,
        errors::ffi::DateTimeWriteError,
        locale_core::ffi::Locale,
        time_formatter::ffi::TimeFormatter,
        time::ffi::Time,
        timezone::ffi::TimeZoneInfo,
    };

    #[cfg(feature = "buffer_provider")]
    use crate::unstable::provider::ffi::DataProvider;

    #[diplomat::opaque]
    #[diplomat::rust_link(icu::datetime::DateTimeFormatter, Struct)]
    pub struct ZonedDateTimeFormatter(
        pub  icu_datetime::DateTimeFormatter<
            icu_datetime::fieldsets::enums::ZonedDateAndTimeFieldSet
        >,
    );

    impl ZonedDateTimeFormatter {
        /// Creates a zoned formatter based on a non-zoned formatter.
        ///
        /// Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
        /// or else unexpected behavior may occur!
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "specific_long")]
        #[diplomat::rust_link(icu::datetime::fieldsets::zone::SpecificLong, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Combo, Struct, hidden)]
        #[cfg(feature = "compiled_data")]
        pub fn create_specific_long(
            locale: &Locale,
            formatter: &DateTimeFormatter,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let zone = icu_datetime::fieldsets::zone::SpecificLong;
            datetime_helpers::datetime_formatter_with_zone(
                &formatter.0,
                locale,
                zone,
                |names| {
                    names
                        .as_mut()
                        .include_time_zone_specific_long_names_with_fallback(
                        )?;
                    Ok(())
                },
                |names, field_set| names.try_into_formatter(
                    field_set
                ),
            )
        }
        
        /// Creates a zoned formatter based on a non-zoned formatter.
        ///
        /// Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
        /// or else unexpected behavior may occur!
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "specific_long_with_provider")]
        #[diplomat::rust_link(icu::datetime::fieldsets::zone::SpecificLong, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Combo, Struct, hidden)]
        #[cfg(feature = "buffer_provider")]
        pub fn create_specific_long_with_provider(
            provider: &DataProvider,
            locale: &Locale,
            formatter: &DateTimeFormatter,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let provider = provider.get()?;
            let zone = icu_datetime::fieldsets::zone::SpecificLong;
            datetime_helpers::datetime_formatter_with_zone(
                &formatter.0,
                locale,
                zone,
                |names| {
                    use icu_provider::buf::AsDeserializingBufferProvider;
                    let provider = provider.as_deserializing();
                    names
                        .as_mut()
                        .load_time_zone_specific_long_names_with_fallback(
                            &provider
                        )?;
                    Ok(())
                },
                |names, field_set| names.try_into_formatter_with_buffer_provider(
                    &provider,
                    field_set
                ),
            )
        }
        
        /// Creates a zoned formatter based on a non-zoned formatter.
        ///
        /// Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
        /// or else unexpected behavior may occur!
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "specific_short")]
        #[diplomat::rust_link(icu::datetime::fieldsets::zone::SpecificShort, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Combo, Struct, hidden)]
        #[cfg(feature = "compiled_data")]
        pub fn create_specific_short(
            locale: &Locale,
            formatter: &DateTimeFormatter,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let zone = icu_datetime::fieldsets::zone::SpecificShort;
            datetime_helpers::datetime_formatter_with_zone(
                &formatter.0,
                locale,
                zone,
                |names| {
                    names
                        .as_mut()
                        .include_time_zone_specific_short_names_with_fallback(
                        )?;
                    Ok(())
                },
                |names, field_set| names.try_into_formatter(
                    field_set
                ),
            )
        }
        
        /// Creates a zoned formatter based on a non-zoned formatter.
        ///
        /// Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
        /// or else unexpected behavior may occur!
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "specific_short_with_provider")]
        #[diplomat::rust_link(icu::datetime::fieldsets::zone::SpecificShort, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Combo, Struct, hidden)]
        #[cfg(feature = "buffer_provider")]
        pub fn create_specific_short_with_provider(
            provider: &DataProvider,
            locale: &Locale,
            formatter: &DateTimeFormatter,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let provider = provider.get()?;
            let zone = icu_datetime::fieldsets::zone::SpecificShort;
            datetime_helpers::datetime_formatter_with_zone(
                &formatter.0,
                locale,
                zone,
                |names| {
                    use icu_provider::buf::AsDeserializingBufferProvider;
                    let provider = provider.as_deserializing();
                    names
                        .as_mut()
                        .load_time_zone_specific_short_names_with_fallback(
                            &provider
                        )?;
                    Ok(())
                },
                |names, field_set| names.try_into_formatter_with_buffer_provider(
                    &provider,
                    field_set
                ),
            )
        }
        
        /// Creates a zoned formatter based on a non-zoned formatter.
        ///
        /// Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
        /// or else unexpected behavior may occur!
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "localized_offset_long")]
        #[diplomat::rust_link(icu::datetime::fieldsets::zone::LocalizedOffsetLong, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Combo, Struct, hidden)]
        #[cfg(feature = "compiled_data")]
        pub fn create_localized_offset_long(
            locale: &Locale,
            formatter: &DateTimeFormatter,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let zone = icu_datetime::fieldsets::zone::LocalizedOffsetLong;
            datetime_helpers::datetime_formatter_with_zone(
                &formatter.0,
                locale,
                zone,
                |names| {
                    names
                        .as_mut()
                        .include_time_zone_localized_offset_names_with_fallback(
                        )?;
                    Ok(())
                },
                |names, field_set| names.try_into_formatter(
                    field_set
                ),
            )
        }
        
        /// Creates a zoned formatter based on a non-zoned formatter.
        ///
        /// Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
        /// or else unexpected behavior may occur!
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "localized_offset_long_with_provider")]
        #[diplomat::rust_link(icu::datetime::fieldsets::zone::LocalizedOffsetLong, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Combo, Struct, hidden)]
        #[cfg(feature = "buffer_provider")]
        pub fn create_localized_offset_long_with_provider(
            provider: &DataProvider,
            locale: &Locale,
            formatter: &DateTimeFormatter,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let provider = provider.get()?;
            let zone = icu_datetime::fieldsets::zone::LocalizedOffsetLong;
            datetime_helpers::datetime_formatter_with_zone(
                &formatter.0,
                locale,
                zone,
                |names| {
                    use icu_provider::buf::AsDeserializingBufferProvider;
                    let provider = provider.as_deserializing();
                    names
                        .as_mut()
                        .load_time_zone_localized_offset_names_with_fallback(
                            &provider
                        )?;
                    Ok(())
                },
                |names, field_set| names.try_into_formatter_with_buffer_provider(
                    &provider,
                    field_set
                ),
            )
        }
        
        /// Creates a zoned formatter based on a non-zoned formatter.
        ///
        /// Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
        /// or else unexpected behavior may occur!
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "localized_offset_short")]
        #[diplomat::rust_link(icu::datetime::fieldsets::zone::LocalizedOffsetShort, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Combo, Struct, hidden)]
        #[cfg(feature = "compiled_data")]
        pub fn create_localized_offset_short(
            locale: &Locale,
            formatter: &DateTimeFormatter,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let zone = icu_datetime::fieldsets::zone::LocalizedOffsetShort;
            datetime_helpers::datetime_formatter_with_zone(
                &formatter.0,
                locale,
                zone,
                |names| {
                    names
                        .as_mut()
                        .include_time_zone_localized_offset_names_with_fallback(
                        )?;
                    Ok(())
                },
                |names, field_set| names.try_into_formatter(
                    field_set
                ),
            )
        }
        
        /// Creates a zoned formatter based on a non-zoned formatter.
        ///
        /// Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
        /// or else unexpected behavior may occur!
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "localized_offset_short_with_provider")]
        #[diplomat::rust_link(icu::datetime::fieldsets::zone::LocalizedOffsetShort, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Combo, Struct, hidden)]
        #[cfg(feature = "buffer_provider")]
        pub fn create_localized_offset_short_with_provider(
            provider: &DataProvider,
            locale: &Locale,
            formatter: &DateTimeFormatter,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let provider = provider.get()?;
            let zone = icu_datetime::fieldsets::zone::LocalizedOffsetShort;
            datetime_helpers::datetime_formatter_with_zone(
                &formatter.0,
                locale,
                zone,
                |names| {
                    use icu_provider::buf::AsDeserializingBufferProvider;
                    let provider = provider.as_deserializing();
                    names
                        .as_mut()
                        .load_time_zone_localized_offset_names_with_fallback(
                            &provider
                        )?;
                    Ok(())
                },
                |names, field_set| names.try_into_formatter_with_buffer_provider(
                    &provider,
                    field_set
                ),
            )
        }
        
        /// Creates a zoned formatter based on a non-zoned formatter.
        ///
        /// Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
        /// or else unexpected behavior may occur!
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "generic_long")]
        #[diplomat::rust_link(icu::datetime::fieldsets::zone::GenericLong, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Combo, Struct, hidden)]
        #[cfg(feature = "compiled_data")]
        pub fn create_generic_long(
            locale: &Locale,
            formatter: &DateTimeFormatter,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let zone = icu_datetime::fieldsets::zone::GenericLong;
            datetime_helpers::datetime_formatter_with_zone(
                &formatter.0,
                locale,
                zone,
                |names| {
                    names
                        .as_mut()
                        .include_time_zone_generic_long_names_with_fallback(
                        )?;
                    Ok(())
                },
                |names, field_set| names.try_into_formatter(
                    field_set
                ),
            )
        }
        
        /// Creates a zoned formatter based on a non-zoned formatter.
        ///
        /// Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
        /// or else unexpected behavior may occur!
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "generic_long_with_provider")]
        #[diplomat::rust_link(icu::datetime::fieldsets::zone::GenericLong, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Combo, Struct, hidden)]
        #[cfg(feature = "buffer_provider")]
        pub fn create_generic_long_with_provider(
            provider: &DataProvider,
            locale: &Locale,
            formatter: &DateTimeFormatter,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let provider = provider.get()?;
            let zone = icu_datetime::fieldsets::zone::GenericLong;
            datetime_helpers::datetime_formatter_with_zone(
                &formatter.0,
                locale,
                zone,
                |names| {
                    use icu_provider::buf::AsDeserializingBufferProvider;
                    let provider = provider.as_deserializing();
                    names
                        .as_mut()
                        .load_time_zone_generic_long_names_with_fallback(
                            &provider
                        )?;
                    Ok(())
                },
                |names, field_set| names.try_into_formatter_with_buffer_provider(
                    &provider,
                    field_set
                ),
            )
        }
        
        /// Creates a zoned formatter based on a non-zoned formatter.
        ///
        /// Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
        /// or else unexpected behavior may occur!
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "generic_short")]
        #[diplomat::rust_link(icu::datetime::fieldsets::zone::GenericShort, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Combo, Struct, hidden)]
        #[diplomat::demo(default_constructor)]
        #[cfg(feature = "compiled_data")]
        pub fn create_generic_short(
            locale: &Locale,
            formatter: &DateTimeFormatter,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let zone = icu_datetime::fieldsets::zone::GenericShort;
            datetime_helpers::datetime_formatter_with_zone(
                &formatter.0,
                locale,
                zone,
                |names| {
                    names
                        .as_mut()
                        .include_time_zone_generic_short_names_with_fallback(
                        )?;
                    Ok(())
                },
                |names, field_set| names.try_into_formatter(
                    field_set
                ),
            )
        }
        
        /// Creates a zoned formatter based on a non-zoned formatter.
        ///
        /// Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
        /// or else unexpected behavior may occur!
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "generic_short_with_provider")]
        #[diplomat::rust_link(icu::datetime::fieldsets::zone::GenericShort, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Combo, Struct, hidden)]
        #[cfg(feature = "buffer_provider")]
        pub fn create_generic_short_with_provider(
            provider: &DataProvider,
            locale: &Locale,
            formatter: &DateTimeFormatter,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let provider = provider.get()?;
            let zone = icu_datetime::fieldsets::zone::GenericShort;
            datetime_helpers::datetime_formatter_with_zone(
                &formatter.0,
                locale,
                zone,
                |names| {
                    use icu_provider::buf::AsDeserializingBufferProvider;
                    let provider = provider.as_deserializing();
                    names
                        .as_mut()
                        .load_time_zone_generic_short_names_with_fallback(
                            &provider
                        )?;
                    Ok(())
                },
                |names, field_set| names.try_into_formatter_with_buffer_provider(
                    &provider,
                    field_set
                ),
            )
        }
        
        /// Creates a zoned formatter based on a non-zoned formatter.
        ///
        /// Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
        /// or else unexpected behavior may occur!
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "location")]
        #[diplomat::rust_link(icu::datetime::fieldsets::zone::Location, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Combo, Struct, hidden)]
        #[cfg(feature = "compiled_data")]
        pub fn create_location(
            locale: &Locale,
            formatter: &DateTimeFormatter,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let zone = icu_datetime::fieldsets::zone::Location;
            datetime_helpers::datetime_formatter_with_zone(
                &formatter.0,
                locale,
                zone,
                |names| {
                    names
                        .as_mut()
                        .include_time_zone_location_names(
                        )?;
                    Ok(())
                },
                |names, field_set| names.try_into_formatter(
                    field_set
                ),
            )
        }
        
        /// Creates a zoned formatter based on a non-zoned formatter.
        ///
        /// Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
        /// or else unexpected behavior may occur!
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "location_with_provider")]
        #[diplomat::rust_link(icu::datetime::fieldsets::zone::Location, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Combo, Struct, hidden)]
        #[cfg(feature = "buffer_provider")]
        pub fn create_location_with_provider(
            provider: &DataProvider,
            locale: &Locale,
            formatter: &DateTimeFormatter,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let provider = provider.get()?;
            let zone = icu_datetime::fieldsets::zone::Location;
            datetime_helpers::datetime_formatter_with_zone(
                &formatter.0,
                locale,
                zone,
                |names| {
                    use icu_provider::buf::AsDeserializingBufferProvider;
                    let provider = provider.as_deserializing();
                    names
                        .as_mut()
                        .load_time_zone_location_names(
                            &provider
                        )?;
                    Ok(())
                },
                |names, field_set| names.try_into_formatter_with_buffer_provider(
                    &provider,
                    field_set
                ),
            )
        }
        
        /// Creates a zoned formatter based on a non-zoned formatter.
        ///
        /// Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
        /// or else unexpected behavior may occur!
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "exemplar_city")]
        #[diplomat::rust_link(icu::datetime::fieldsets::zone::ExemplarCity, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Combo, Struct, hidden)]
        #[cfg(feature = "compiled_data")]
        pub fn create_exemplar_city(
            locale: &Locale,
            formatter: &DateTimeFormatter,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let zone = icu_datetime::fieldsets::zone::ExemplarCity;
            datetime_helpers::datetime_formatter_with_zone(
                &formatter.0,
                locale,
                zone,
                |names| {
                    names
                        .as_mut()
                        .include_time_zone_exemplar_city_names(
                        )?;
                    Ok(())
                },
                |names, field_set| names.try_into_formatter(
                    field_set
                ),
            )
        }
        
        /// Creates a zoned formatter based on a non-zoned formatter.
        ///
        /// Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
        /// or else unexpected behavior may occur!
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "exemplar_city_with_provider")]
        #[diplomat::rust_link(icu::datetime::fieldsets::zone::ExemplarCity, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Combo, Struct, hidden)]
        #[cfg(feature = "buffer_provider")]
        pub fn create_exemplar_city_with_provider(
            provider: &DataProvider,
            locale: &Locale,
            formatter: &DateTimeFormatter,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let provider = provider.get()?;
            let zone = icu_datetime::fieldsets::zone::ExemplarCity;
            datetime_helpers::datetime_formatter_with_zone(
                &formatter.0,
                locale,
                zone,
                |names| {
                    use icu_provider::buf::AsDeserializingBufferProvider;
                    let provider = provider.as_deserializing();
                    names
                        .as_mut()
                        .load_time_zone_exemplar_city_names(
                            &provider
                        )?;
                    Ok(())
                },
                |names, field_set| names.try_into_formatter_with_buffer_provider(
                    &provider,
                    field_set
                ),
            )
        }
        
        #[diplomat::rust_link(icu::datetime::DateTimeFormatter::format, FnInStruct)]
        #[diplomat::rust_link(icu::datetime::FormattedDateTime, Struct, hidden)]
        #[diplomat::rust_link(icu::datetime::FormattedDateTime::to_string, FnInStruct, hidden)]
        pub fn format_iso(
            &self,
            date: &IsoDate,
            time: &Time,
            zone: &TimeZoneInfo,
            write: &mut diplomat_runtime::DiplomatWrite,
        ) -> Result<(), DateTimeWriteError> {
            let mut input = icu_datetime::unchecked::DateTimeInputUnchecked::default();
            let date_in_calendar = date.0.to_calendar(self.0.calendar());
            input.set_date_fields_unchecked(date_in_calendar); // calendar conversion on previous line
            input.set_time_fields(time.0);
            input.set_time_zone_id(zone.id);
            if let Some(offset) = zone.offset {
                input.set_time_zone_utc_offset(offset);
            }
            if let Some(zone_name_timestamp) = zone.zone_name_timestamp {
                input.set_time_zone_name_timestamp(zone_name_timestamp);
            }
            else {
                input.set_time_zone_name_timestamp(icu_time::zone::ZoneNameTimestamp::from_date_time_iso(icu_time::DateTime {
                    date: date.0,
                    time: time.0
                }))
            }
            if let Some(variant) = zone.variant {
                input.set_time_zone_variant(variant);
            }
            let _infallible = self
                .0
                .format_unchecked(input)
                .try_write_to(write)
                .ok()
                .transpose()?;
            Ok(())
        }
    }
    

    #[diplomat::opaque]
    #[diplomat::rust_link(icu::datetime::FixedCalendarDateTimeFormatter, Struct)]
    pub struct ZonedDateTimeFormatterGregorian(
        pub  icu_datetime::FixedCalendarDateTimeFormatter<
            Gregorian,
            icu_datetime::fieldsets::enums::ZonedDateAndTimeFieldSet
        >,
    );

    impl ZonedDateTimeFormatterGregorian {
        /// Creates a zoned formatter based on a non-zoned formatter.
        ///
        /// Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
        /// or else unexpected behavior may occur!
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "specific_long")]
        #[diplomat::rust_link(icu::datetime::fieldsets::zone::SpecificLong, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Combo, Struct, hidden)]
        #[cfg(feature = "compiled_data")]
        pub fn create_specific_long(
            locale: &Locale,
            formatter: &DateTimeFormatterGregorian,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let zone = icu_datetime::fieldsets::zone::SpecificLong;
            datetime_helpers::datetime_formatter_gregorian_with_zone(
                &formatter.0,
                locale,
                zone,
                |names| {
                    names
                        .include_time_zone_specific_long_names_with_fallback(
                        )?;
                    Ok(())
                },
                |names, field_set| names.try_into_formatter(
                    field_set
                ),
            )
        }
        
        /// Creates a zoned formatter based on a non-zoned formatter.
        ///
        /// Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
        /// or else unexpected behavior may occur!
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "specific_long_with_provider")]
        #[diplomat::rust_link(icu::datetime::fieldsets::zone::SpecificLong, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Combo, Struct, hidden)]
        #[cfg(feature = "buffer_provider")]
        pub fn create_specific_long_with_provider(
            provider: &DataProvider,
            locale: &Locale,
            formatter: &DateTimeFormatterGregorian,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let provider = provider.get()?;
            let zone = icu_datetime::fieldsets::zone::SpecificLong;
            datetime_helpers::datetime_formatter_gregorian_with_zone(
                &formatter.0,
                locale,
                zone,
                |names| {
                    use icu_provider::buf::AsDeserializingBufferProvider;
                    let provider = provider.as_deserializing();
                    names
                        .load_time_zone_specific_long_names_with_fallback(
                            &provider
                        )?;
                    Ok(())
                },
                |names, field_set| names.try_into_formatter_with_buffer_provider(
                    &provider,
                    field_set
                ),
            )
        }
        
        /// Creates a zoned formatter based on a non-zoned formatter.
        ///
        /// Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
        /// or else unexpected behavior may occur!
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "specific_short")]
        #[diplomat::rust_link(icu::datetime::fieldsets::zone::SpecificShort, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Combo, Struct, hidden)]
        #[cfg(feature = "compiled_data")]
        pub fn create_specific_short(
            locale: &Locale,
            formatter: &DateTimeFormatterGregorian,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let zone = icu_datetime::fieldsets::zone::SpecificShort;
            datetime_helpers::datetime_formatter_gregorian_with_zone(
                &formatter.0,
                locale,
                zone,
                |names| {
                    names
                        .include_time_zone_specific_short_names_with_fallback(
                        )?;
                    Ok(())
                },
                |names, field_set| names.try_into_formatter(
                    field_set
                ),
            )
        }
        
        /// Creates a zoned formatter based on a non-zoned formatter.
        ///
        /// Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
        /// or else unexpected behavior may occur!
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "specific_short_with_provider")]
        #[diplomat::rust_link(icu::datetime::fieldsets::zone::SpecificShort, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Combo, Struct, hidden)]
        #[cfg(feature = "buffer_provider")]
        pub fn create_specific_short_with_provider(
            provider: &DataProvider,
            locale: &Locale,
            formatter: &DateTimeFormatterGregorian,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let provider = provider.get()?;
            let zone = icu_datetime::fieldsets::zone::SpecificShort;
            datetime_helpers::datetime_formatter_gregorian_with_zone(
                &formatter.0,
                locale,
                zone,
                |names| {
                    use icu_provider::buf::AsDeserializingBufferProvider;
                    let provider = provider.as_deserializing();
                    names
                        .load_time_zone_specific_short_names_with_fallback(
                            &provider
                        )?;
                    Ok(())
                },
                |names, field_set| names.try_into_formatter_with_buffer_provider(
                    &provider,
                    field_set
                ),
            )
        }
        
        /// Creates a zoned formatter based on a non-zoned formatter.
        ///
        /// Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
        /// or else unexpected behavior may occur!
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "localized_offset_long")]
        #[diplomat::rust_link(icu::datetime::fieldsets::zone::LocalizedOffsetLong, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Combo, Struct, hidden)]
        #[cfg(feature = "compiled_data")]
        pub fn create_localized_offset_long(
            locale: &Locale,
            formatter: &DateTimeFormatterGregorian,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let zone = icu_datetime::fieldsets::zone::LocalizedOffsetLong;
            datetime_helpers::datetime_formatter_gregorian_with_zone(
                &formatter.0,
                locale,
                zone,
                |names| {
                    names
                        .include_time_zone_localized_offset_names_with_fallback(
                        )?;
                    Ok(())
                },
                |names, field_set| names.try_into_formatter(
                    field_set
                ),
            )
        }
        
        /// Creates a zoned formatter based on a non-zoned formatter.
        ///
        /// Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
        /// or else unexpected behavior may occur!
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "localized_offset_long_with_provider")]
        #[diplomat::rust_link(icu::datetime::fieldsets::zone::LocalizedOffsetLong, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Combo, Struct, hidden)]
        #[cfg(feature = "buffer_provider")]
        pub fn create_localized_offset_long_with_provider(
            provider: &DataProvider,
            locale: &Locale,
            formatter: &DateTimeFormatterGregorian,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let provider = provider.get()?;
            let zone = icu_datetime::fieldsets::zone::LocalizedOffsetLong;
            datetime_helpers::datetime_formatter_gregorian_with_zone(
                &formatter.0,
                locale,
                zone,
                |names| {
                    use icu_provider::buf::AsDeserializingBufferProvider;
                    let provider = provider.as_deserializing();
                    names
                        .load_time_zone_localized_offset_names_with_fallback(
                            &provider
                        )?;
                    Ok(())
                },
                |names, field_set| names.try_into_formatter_with_buffer_provider(
                    &provider,
                    field_set
                ),
            )
        }
        
        /// Creates a zoned formatter based on a non-zoned formatter.
        ///
        /// Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
        /// or else unexpected behavior may occur!
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "localized_offset_short")]
        #[diplomat::rust_link(icu::datetime::fieldsets::zone::LocalizedOffsetShort, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Combo, Struct, hidden)]
        #[cfg(feature = "compiled_data")]
        pub fn create_localized_offset_short(
            locale: &Locale,
            formatter: &DateTimeFormatterGregorian,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let zone = icu_datetime::fieldsets::zone::LocalizedOffsetShort;
            datetime_helpers::datetime_formatter_gregorian_with_zone(
                &formatter.0,
                locale,
                zone,
                |names| {
                    names
                        .include_time_zone_localized_offset_names_with_fallback(
                        )?;
                    Ok(())
                },
                |names, field_set| names.try_into_formatter(
                    field_set
                ),
            )
        }
        
        /// Creates a zoned formatter based on a non-zoned formatter.
        ///
        /// Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
        /// or else unexpected behavior may occur!
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "localized_offset_short_with_provider")]
        #[diplomat::rust_link(icu::datetime::fieldsets::zone::LocalizedOffsetShort, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Combo, Struct, hidden)]
        #[cfg(feature = "buffer_provider")]
        pub fn create_localized_offset_short_with_provider(
            provider: &DataProvider,
            locale: &Locale,
            formatter: &DateTimeFormatterGregorian,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let provider = provider.get()?;
            let zone = icu_datetime::fieldsets::zone::LocalizedOffsetShort;
            datetime_helpers::datetime_formatter_gregorian_with_zone(
                &formatter.0,
                locale,
                zone,
                |names| {
                    use icu_provider::buf::AsDeserializingBufferProvider;
                    let provider = provider.as_deserializing();
                    names
                        .load_time_zone_localized_offset_names_with_fallback(
                            &provider
                        )?;
                    Ok(())
                },
                |names, field_set| names.try_into_formatter_with_buffer_provider(
                    &provider,
                    field_set
                ),
            )
        }
        
        /// Creates a zoned formatter based on a non-zoned formatter.
        ///
        /// Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
        /// or else unexpected behavior may occur!
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "generic_long")]
        #[diplomat::rust_link(icu::datetime::fieldsets::zone::GenericLong, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Combo, Struct, hidden)]
        #[cfg(feature = "compiled_data")]
        pub fn create_generic_long(
            locale: &Locale,
            formatter: &DateTimeFormatterGregorian,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let zone = icu_datetime::fieldsets::zone::GenericLong;
            datetime_helpers::datetime_formatter_gregorian_with_zone(
                &formatter.0,
                locale,
                zone,
                |names| {
                    names
                        .include_time_zone_generic_long_names_with_fallback(
                        )?;
                    Ok(())
                },
                |names, field_set| names.try_into_formatter(
                    field_set
                ),
            )
        }
        
        /// Creates a zoned formatter based on a non-zoned formatter.
        ///
        /// Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
        /// or else unexpected behavior may occur!
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "generic_long_with_provider")]
        #[diplomat::rust_link(icu::datetime::fieldsets::zone::GenericLong, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Combo, Struct, hidden)]
        #[cfg(feature = "buffer_provider")]
        pub fn create_generic_long_with_provider(
            provider: &DataProvider,
            locale: &Locale,
            formatter: &DateTimeFormatterGregorian,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let provider = provider.get()?;
            let zone = icu_datetime::fieldsets::zone::GenericLong;
            datetime_helpers::datetime_formatter_gregorian_with_zone(
                &formatter.0,
                locale,
                zone,
                |names| {
                    use icu_provider::buf::AsDeserializingBufferProvider;
                    let provider = provider.as_deserializing();
                    names
                        .load_time_zone_generic_long_names_with_fallback(
                            &provider
                        )?;
                    Ok(())
                },
                |names, field_set| names.try_into_formatter_with_buffer_provider(
                    &provider,
                    field_set
                ),
            )
        }
        
        /// Creates a zoned formatter based on a non-zoned formatter.
        ///
        /// Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
        /// or else unexpected behavior may occur!
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "generic_short")]
        #[diplomat::rust_link(icu::datetime::fieldsets::zone::GenericShort, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Combo, Struct, hidden)]
        #[diplomat::demo(default_constructor)]
        #[cfg(feature = "compiled_data")]
        pub fn create_generic_short(
            locale: &Locale,
            formatter: &DateTimeFormatterGregorian,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let zone = icu_datetime::fieldsets::zone::GenericShort;
            datetime_helpers::datetime_formatter_gregorian_with_zone(
                &formatter.0,
                locale,
                zone,
                |names| {
                    names
                        .include_time_zone_generic_short_names_with_fallback(
                        )?;
                    Ok(())
                },
                |names, field_set| names.try_into_formatter(
                    field_set
                ),
            )
        }
        
        /// Creates a zoned formatter based on a non-zoned formatter.
        ///
        /// Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
        /// or else unexpected behavior may occur!
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "generic_short_with_provider")]
        #[diplomat::rust_link(icu::datetime::fieldsets::zone::GenericShort, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Combo, Struct, hidden)]
        #[cfg(feature = "buffer_provider")]
        pub fn create_generic_short_with_provider(
            provider: &DataProvider,
            locale: &Locale,
            formatter: &DateTimeFormatterGregorian,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let provider = provider.get()?;
            let zone = icu_datetime::fieldsets::zone::GenericShort;
            datetime_helpers::datetime_formatter_gregorian_with_zone(
                &formatter.0,
                locale,
                zone,
                |names| {
                    use icu_provider::buf::AsDeserializingBufferProvider;
                    let provider = provider.as_deserializing();
                    names
                        .load_time_zone_generic_short_names_with_fallback(
                            &provider
                        )?;
                    Ok(())
                },
                |names, field_set| names.try_into_formatter_with_buffer_provider(
                    &provider,
                    field_set
                ),
            )
        }
        
        /// Creates a zoned formatter based on a non-zoned formatter.
        ///
        /// Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
        /// or else unexpected behavior may occur!
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "location")]
        #[diplomat::rust_link(icu::datetime::fieldsets::zone::Location, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Combo, Struct, hidden)]
        #[cfg(feature = "compiled_data")]
        pub fn create_location(
            locale: &Locale,
            formatter: &DateTimeFormatterGregorian,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let zone = icu_datetime::fieldsets::zone::Location;
            datetime_helpers::datetime_formatter_gregorian_with_zone(
                &formatter.0,
                locale,
                zone,
                |names| {
                    names
                        .include_time_zone_location_names(
                        )?;
                    Ok(())
                },
                |names, field_set| names.try_into_formatter(
                    field_set
                ),
            )
        }
        
        /// Creates a zoned formatter based on a non-zoned formatter.
        ///
        /// Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
        /// or else unexpected behavior may occur!
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "location_with_provider")]
        #[diplomat::rust_link(icu::datetime::fieldsets::zone::Location, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Combo, Struct, hidden)]
        #[cfg(feature = "buffer_provider")]
        pub fn create_location_with_provider(
            provider: &DataProvider,
            locale: &Locale,
            formatter: &DateTimeFormatterGregorian,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let provider = provider.get()?;
            let zone = icu_datetime::fieldsets::zone::Location;
            datetime_helpers::datetime_formatter_gregorian_with_zone(
                &formatter.0,
                locale,
                zone,
                |names| {
                    use icu_provider::buf::AsDeserializingBufferProvider;
                    let provider = provider.as_deserializing();
                    names
                        .load_time_zone_location_names(
                            &provider
                        )?;
                    Ok(())
                },
                |names, field_set| names.try_into_formatter_with_buffer_provider(
                    &provider,
                    field_set
                ),
            )
        }
        
        /// Creates a zoned formatter based on a non-zoned formatter.
        ///
        /// Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
        /// or else unexpected behavior may occur!
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "exemplar_city")]
        #[diplomat::rust_link(icu::datetime::fieldsets::zone::ExemplarCity, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Combo, Struct, hidden)]
        #[cfg(feature = "compiled_data")]
        pub fn create_exemplar_city(
            locale: &Locale,
            formatter: &DateTimeFormatterGregorian,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let zone = icu_datetime::fieldsets::zone::ExemplarCity;
            datetime_helpers::datetime_formatter_gregorian_with_zone(
                &formatter.0,
                locale,
                zone,
                |names| {
                    names
                        .include_time_zone_exemplar_city_names(
                        )?;
                    Ok(())
                },
                |names, field_set| names.try_into_formatter(
                    field_set
                ),
            )
        }
        
        /// Creates a zoned formatter based on a non-zoned formatter.
        ///
        /// Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
        /// or else unexpected behavior may occur!
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "exemplar_city_with_provider")]
        #[diplomat::rust_link(icu::datetime::fieldsets::zone::ExemplarCity, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Combo, Struct, hidden)]
        #[cfg(feature = "buffer_provider")]
        pub fn create_exemplar_city_with_provider(
            provider: &DataProvider,
            locale: &Locale,
            formatter: &DateTimeFormatterGregorian,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let provider = provider.get()?;
            let zone = icu_datetime::fieldsets::zone::ExemplarCity;
            datetime_helpers::datetime_formatter_gregorian_with_zone(
                &formatter.0,
                locale,
                zone,
                |names| {
                    use icu_provider::buf::AsDeserializingBufferProvider;
                    let provider = provider.as_deserializing();
                    names
                        .load_time_zone_exemplar_city_names(
                            &provider
                        )?;
                    Ok(())
                },
                |names, field_set| names.try_into_formatter_with_buffer_provider(
                    &provider,
                    field_set
                ),
            )
        }
        
        #[diplomat::rust_link(icu::datetime::FixedCalendarDateTimeFormatter::format, FnInStruct)]
        #[diplomat::rust_link(icu::datetime::FormattedDateTime, Struct, hidden)]
        #[diplomat::rust_link(icu::datetime::FormattedDateTime::to_string, FnInStruct, hidden)]
        pub fn format_iso(
            &self,
            date: &IsoDate,
            time: &Time,
            zone: &TimeZoneInfo,
            write: &mut diplomat_runtime::DiplomatWrite,
        ) -> Result<(), DateTimeWriteError> {
            let mut input = icu_datetime::unchecked::DateTimeInputUnchecked::default();
            let date_in_calendar = date.0.to_calendar(Gregorian);
            input.set_date_fields_unchecked(date_in_calendar); // calendar conversion on previous line
            input.set_time_fields(time.0);
            input.set_time_zone_id(zone.id);
            if let Some(offset) = zone.offset {
                input.set_time_zone_utc_offset(offset);
            }
            if let Some(zone_name_timestamp) = zone.zone_name_timestamp {
                input.set_time_zone_name_timestamp(zone_name_timestamp);
            }
            else {
                input.set_time_zone_name_timestamp(icu_time::zone::ZoneNameTimestamp::from_date_time_iso(icu_time::DateTime {
                    date: date.0,
                    time: time.0
                }))
            }
            if let Some(variant) = zone.variant {
                input.set_time_zone_variant(variant);
            }
            let _infallible = self
                .0
                .format_unchecked(input)
                .try_write_to(write)
                .ok()
                .transpose()?;
            Ok(())
        }
    }
    
}
