/*
 * Decompiled with CFR 0.152.
 */
package adql.parser;

import adql.parser.grammar.ADQLGrammar;
import adql.parser.grammar.ParseException;
import adql.parser.grammar.Token;
import adql.parser.grammar.TokenMgrError;
import java.util.HashMap;
import java.util.Map;

public class QueryFixer {
    protected final ADQLGrammar grammarParser;
    protected final Map<String, String> mapRegexUnicodeConfusable;
    protected final String REGEX_DASH = "[-\u02d7\u06d4\u2010\u2011\u2012\u2013\u2043\u2212\u2796\u2cba\ufe58\u2014\u2015\u207b\u208b\u0096\u058a\ufe63\uff0d]";
    protected final String REGEX_UNDERSCORE = "[_\u07fa\ufe4d\ufe4e\ufe4f]";
    protected final String REGEX_QUOTE = "['`\u00b4\u02b9\u02bb\u02bc\u02bd\u02be\u02c8\u02ca\u02cb\u02f4\u0374\u0384\u055a\u055d\u05d9\u05f3\u07f4\u07f5\u144a\u16cc\u1fbd\u1fbf\u1fef\u1ffd\u1ffe\u2018\u2019\u201b\u2032\u2035\ua78c\uff07\uff40]";
    protected final String REGEX_DOUBLE_QUOTE = "[\u02ba\u02dd\u02ee\u02f6\u05f2\u05f4\u1cd3\u201c\u201d\u201f\u2033\u2036\u3003\uff02]";
    protected final String REGEX_STOP = "[.\u0660\u06f0\u0701\u0702\u2024\ua4f8\ua60e]";
    protected final String REGEX_PLUS = "[+\u16ed\u2795]";
    protected final String REGEX_SPACE = "[ \u00a0\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\uf0a0]";
    protected final String REGEX_LESS_THAN = "[<\u02c2\u1438\u16b2\u2039\u276e]";
    protected final String REGEX_GREATER_THAN = "[>\u02c3\u1433\u203a\u276f]";
    protected final String REGEX_EQUAL = "[=\u1400\u2e40\u30a0\ua4ff]";

    public QueryFixer(ADQLGrammar grammar) throws NullPointerException {
        if (grammar == null) {
            throw new NullPointerException("Missing ADQL grammar parser!");
        }
        this.grammarParser = grammar;
        this.mapRegexUnicodeConfusable = new HashMap<String, String>(10);
        this.mapRegexUnicodeConfusable.put("-", "[-\u02d7\u06d4\u2010\u2011\u2012\u2013\u2043\u2212\u2796\u2cba\ufe58\u2014\u2015\u207b\u208b\u0096\u058a\ufe63\uff0d]");
        this.mapRegexUnicodeConfusable.put("_", "[_\u07fa\ufe4d\ufe4e\ufe4f]");
        this.mapRegexUnicodeConfusable.put("'", "['`\u00b4\u02b9\u02bb\u02bc\u02bd\u02be\u02c8\u02ca\u02cb\u02f4\u0374\u0384\u055a\u055d\u05d9\u05f3\u07f4\u07f5\u144a\u16cc\u1fbd\u1fbf\u1fef\u1ffd\u1ffe\u2018\u2019\u201b\u2032\u2035\ua78c\uff07\uff40]");
        this.mapRegexUnicodeConfusable.put("\"", "[\u02ba\u02dd\u02ee\u02f6\u05f2\u05f4\u1cd3\u201c\u201d\u201f\u2033\u2036\u3003\uff02]");
        this.mapRegexUnicodeConfusable.put(".", "[.\u0660\u06f0\u0701\u0702\u2024\ua4f8\ua60e]");
        this.mapRegexUnicodeConfusable.put("+", "[+\u16ed\u2795]");
        this.mapRegexUnicodeConfusable.put(" ", "[ \u00a0\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\uf0a0]");
        this.mapRegexUnicodeConfusable.put("<", "[<\u02c2\u1438\u16b2\u2039\u276e]");
        this.mapRegexUnicodeConfusable.put(">", "[>\u02c3\u1433\u203a\u276f]");
        this.mapRegexUnicodeConfusable.put("=", "[=\u1400\u2e40\u30a0\ua4ff]");
    }

    public String fix(String adqlQuery) throws ParseException {
        StringBuffer suggestedQuery = new StringBuffer();
        adqlQuery = this.replaceUnicodeConfusables(adqlQuery);
        adqlQuery = adqlQuery.replaceAll("(\r\n|\r|\n)", System.getProperty("line.separator")).replaceAll("\t", "    ");
        ADQLGrammar.Tokenizer tokenizer = this.grammarParser.getTokenizer(adqlQuery);
        String[] lines = adqlQuery.split(System.getProperty("line.separator"));
        try {
            int lastLine = 1;
            int lastCol = 1;
            Token token = null;
            Token nextToken = tokenizer.nextToken();
            do {
                nextToken = this.grammarParser.isEnd(token = nextToken) ? null : tokenizer.nextToken();
                String suggestedToken = this.mustEscape(token, nextToken) ? "\"" + token.image + "\"" : token.image;
                if (lastLine == token.beginLine) {
                    if (this.grammarParser.isEOF(token)) {
                        suggestedQuery.append(lines[lastLine - 1].substring(lastCol - 1));
                    } else {
                        suggestedQuery.append(lines[lastLine - 1].substring(lastCol - 1, token.beginColumn - (this.grammarParser.isEnd(token) ? 0 : 1)));
                    }
                    lastCol = token.endColumn + 1;
                } else {
                    do {
                        suggestedQuery.append(lines[lastLine - 1].substring(lastCol - 1)).append('\n');
                        lastCol = 1;
                    } while (++lastLine < token.beginLine);
                    if (lastCol < token.beginColumn) {
                        suggestedQuery.append(lines[lastLine - 1].substring(lastCol - 1, token.beginColumn - 1));
                    }
                    lastCol = token.endColumn + 1;
                }
                suggestedQuery.append(suggestedToken);
            } while (!this.grammarParser.isEnd(token));
        }
        catch (TokenMgrError err) {
            throw new ParseException(err);
        }
        return suggestedQuery.toString();
    }

    protected String replaceUnicodeConfusables(String adqlQuery) {
        String newAdqlQuery = adqlQuery;
        for (Map.Entry<String, String> confusable : this.mapRegexUnicodeConfusable.entrySet()) {
            newAdqlQuery = newAdqlQuery.replaceAll(confusable.getValue(), confusable.getKey());
        }
        return newAdqlQuery;
    }

    protected boolean mustEscape(Token token, Token nextToken) {
        if (this.grammarParser.isSQLReservedWord(token)) {
            return true;
        }
        if (this.grammarParser.isRegularIdentifierCandidate(token)) {
            return !this.grammarParser.isRegularIdentifier(token.image);
        }
        return token.isFunctionName && !this.grammarParser.isLeftPar(nextToken);
    }
}

