/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * This file is dual-licensed.
 * In addition to the GPLv3 license mentioned above, this code is also
 * licensed under LGPL 2.1. See LICENSES/COPYING.LGPL file for the
 * full text of the license.
 *
 */

/* Detection tables for the ADI 1 series. */
/* These games are part of the Adi series. For more information, refer to our wiki: https://wiki.scummvm.org/index.php?title=Adi_Games */

#ifndef GOB_DETECTION_TABLES_ADI1_H
#define GOB_DETECTION_TABLES_ADI1_H

// -- French: ADI --

{
	{
		"adi1",
		MetaEngineDetection::GAME_NOT_IMPLEMENTED, // CE1
		AD_ENTRY1s("adi2.stk", "77f2b5baa30f02eecf0a94f05316c031", 334671),
		FR_FRA,
		kPlatformDOS,
		ADGF_UNSUPPORTED,
		GUIO0()
	},
	kFeaturesEGA,
	"adi2.stk", "ediintro.tot", 0
},
{
	{
		"adi1",
		MetaEngineDetection::GAME_NOT_IMPLEMENTED, // CE2
		AD_ENTRY1s("adi2.stk", "1f22d389a3f0857cacb25bb174107145", 323562),
		FR_FRA,
		kPlatformDOS,
		ADGF_UNSUPPORTED,
		GUIO0()
	},
	kFeaturesEGA,
	"adi2.stk", "ediintro.tot", 0
},
{
	{
		"adi1",
		MetaEngineDetection::GAME_NOT_IMPLEMENTED, // CM1
		AD_ENTRY1s("adi2.stk", "78125e8b87dad64d014648883a553b87", 327022),
		FR_FRA,
		kPlatformDOS,
		ADGF_UNSUPPORTED,
		GUIO0()
	},
	kFeaturesEGA,
	"adi2.stk", "ediintro.tot", 0
},
{
	{
		"adi1",
		MetaEngineDetection::GAME_NOT_IMPLEMENTED, // CM2
		AD_ENTRY1s("adi2.stk", "9084badfe3631ece4598c4016dcee4eb", 335032),
		FR_FRA,
		kPlatformDOS,
		ADGF_UNSUPPORTED,
		GUIO0()
	},
	kFeaturesEGA,
	"adi2.stk", "ediintro.tot", 0
},
{
	{
		"adi1",
		MetaEngineDetection::GAME_NOT_IMPLEMENTED, // 3ème
		AD_ENTRY1s("adi2.stk", "37de6bae596262071ad23131dc85e505", 334432),
		FR_FRA,
		kPlatformDOS,
		ADGF_UNSUPPORTED,
		GUIO0()
	},
	kFeaturesEGA,
	"adi2.stk", "ediintro.tot", 0
},
{
	{
		"adi1",
		MetaEngineDetection::GAME_NOT_IMPLEMENTED, // 4ème
		AD_ENTRY1s("adi2.stk", "d662248b3b27e53fccd5355351075236", 344496),
		FR_FRA,
		kPlatformDOS,
		ADGF_UNSUPPORTED,
		GUIO0()
	},
	kFeaturesEGA,
	"adi2.stk", "ediintro.tot", 0
},
{
	{
		"adi1",
		MetaEngineDetection::GAME_NOT_IMPLEMENTED, // 5ème
		AD_ENTRY1s("adi2.stk", "38ebd0ae0bdd0facee0084e305bf5152", 335780),
		FR_FRA,
		kPlatformDOS,
		ADGF_UNSUPPORTED,
		GUIO0()
	},
	kFeaturesEGA,
	"adi2.stk", "ediintro.tot", 0
},
{
	{
		"adi1",
		MetaEngineDetection::GAME_NOT_IMPLEMENTED, // 6ème
		AD_ENTRY1s("adi2.stk", "2f24f14c58a062ab25dab7de8fb2489b", 335780),
		FR_FRA,
		kPlatformDOS,
		ADGF_UNSUPPORTED,
		GUIO0()
	},
	kFeaturesEGA,
	"adi2.stk", "ediintro.tot", 0
},
{
	{
		"adi1",
		MetaEngineDetection::GAME_NOT_IMPLEMENTED, // ADIBAC
		AD_ENTRY1s("adi2.stk", "93377cd4582554258ed421239760a434", 307512),
		FR_FRA,
		kPlatformDOS,
		ADGF_NO_FLAGS,
		GUIO0()
	},
	kFeaturesEGA,
	"adi2.stk", "ediintro.tot", 0
},


// -- English: ADI --

{
	{
		"adi1",
		MetaEngineDetection::GAME_NOT_IMPLEMENTED, // English 12/13
		AD_ENTRY1s("adi2.stk", "a3e04e7c575fff9e42d6912d127c2e30", 324550),
		EN_GRB,
		kPlatformDOS,
		ADGF_UNSUPPORTED,
		GUIO0()
	},
	kFeaturesEGA,
	"adi2.stk", "ediintro.tot", 0
},

// -- Italian: ADÍ --

{
	{
		"adi1",
		MetaEngineDetection::GAME_NOT_IMPLEMENTED,
		AD_ENTRY1s("adi2.stk", "955fd172fb2bae38e25d80e6584fca9e", 319718),
		IT_ITA,
		kPlatformDOS,
		ADGF_UNSUPPORTED,
		GUIO0()
	},
	kFeaturesEGA,
	"adi2.stk", "ediintro.tot", 0
},
{
	{
		"adi1",
		MetaEngineDetection::GAME_NOT_IMPLEMENTED, // Matematica 2a
		AD_ENTRY1s("adi2.stk", "ff6bc3bd581c686a2796c4b6aee9e27d", 329888),
		IT_ITA,
		kPlatformDOS,
		ADGF_UNSUPPORTED,
		GUIO0()
	},
	kFeaturesEGA,
	"adi2.stk", "ediintro.tot", 0
},

// -- Spanish: Adi --

{
	{
		"adi1",
		MetaEngineDetection::GAME_NOT_IMPLEMENTED, // Lengua Espanola 6
		AD_ENTRY1s("adi2.stk", "bbbe5880b2f62145f8f84b63e5105c95", 317067),
		ES_ESP,
		kPlatformDOS,
		ADGF_UNSUPPORTED,
		GUIO0()
	},
	kFeaturesEGA,
	"adi2.stk", "ediintro.tot", 0
},
{
	{
		"adi1",
		MetaEngineDetection::GAME_NOT_IMPLEMENTED, // Lengua Espanola 8
		AD_ENTRY1s("adi2.stk", "d5c1f812093b751a445d110734b69519", 327672),
		ES_ESP,
		kPlatformDOS,
		ADGF_UNSUPPORTED,
		GUIO0()
	},
	kFeaturesEGA,
	"adi2.stk", "ediintro.tot", 0
},


#endif // GOB_DETECTION_TABLES_ADI1_H
