'use strict';

module.exports = function () {
  const pkcs8 = Buffer.from(
    '308204bf020100300d06092a864886f70d0101010500048204a9308204a50201000282' +
    '010100d3576092e62957364544e7e4233b7bdb293db2085122c479328546f9f0f712f6' +
    '57c4b17868c930908cc594f7ed00c01442c1af04c2f678a48ba2c80fd1713e30b5ac50' +
    '787ac3516589f171967f6386ada34900a6bb04eecea42bf043ced9a0f94d0cc09e919b' +
    '9d7166c08ab6ce204640aea4c4920db6d86eb916d0dcc0f4341a10380429e7e1032144' +
    'ea949de8f6c0ccbf95fa8e928d70d8a38ce168db45f6f134663d6f656f5ceabc725da8' +
    'c02aabeaaa13ac36a75cc0bae135df3114b66589c7ed3cb61559ae5a384f162bfa80db' +
    'e4617f86c3f1d010c94fe2c9bf019a6e63b3efc028d43cee611c85ec263c906c463772' +
    'c6911b19eec096ca76ec5e31e1e3020301000102820101008b375ccb87c825c5ff3d53' +
    'd009916e9641057e18527227a07ab226be1088813a3b38bb7b48f377055165fa2a9339' +
    'd24dc667d5c5ba3427e6a481176eac15ffd49068311e1c283b9f3a8e0cb809b4630c50' +
    'aa8f3e45a60b359e19bf8cbb5ecad64e761f1095743ff36aaf5cf0ecb97fedaddda60b' +
    '5bf35d811a75b822230cfaa0192fad40547e275448aa3316bf8e2b4ce0854fc7708b53' +
    '7ba22d13210b09aec37a2759efc082a1531b23a91730037dde4ef26b5f96efdcc39fd3' +
    '4c345ad51cbbe44fe58b8a3b4ec997866c086dff1b8831ef0a1fea263cf7dacd03c04c' +
    'bcc2b279e57fa5b953996bfb1dd68817af7fb42cdef7a5294a57fac2b8ad739f1b0299' +
    '02818100fbf833c2c631c970240c8e7485f06a3ea2a84822511a8627dd464ef8afaf71' +
    '48d1a425b6b8657ddd5246832b8e533020c5bbb568855a6aec3e4221d793f1dc5b2f25' +
    '84e2415e48e9a2bd292b134031f99c8eb42fc0bcd0449bf22ce6dec97014efe5ac93eb' +
    'e835877656252cbbb16c415b67b184d2284568a277d59335585cfd02818100d6b8ce27' +
    'c7295d5d16fc3570ed64c8da9303fad29488c1a65e9ad711f90370187dbbfd81316d69' +
    '648bc88cc5c83551afff45debacfb61105f709e4c30809b90031ebd686244496c6f69e' +
    '692ebdc814f64239f4ad15756ecb78c5a5b09931db183077c546a38c4c743889ad3d3e' +
    'd079b5622ed0120fa0e1f93b593db7d852e05f02818038874b9d83f78178ce2d9efc17' +
    '5c83897fd67f306bbfa69f64ee342368ced47c80c3f1ce177a758d64bafb0c9786a442' +
    '85fa01cdec3507cdee7dc9b7e2b21d3cbbcc100eee9967843b057329fdcca62998ed0f' +
    '11b38ce8b0abc7de39017c71cfd0ae57546c559144cdd0afd0645f7ea8ff07b974d1ed' +
    '44fd1f8e00f560bf6d45028181008529ef9073cf8f7b5ff9e21abadf3a4173d3900670' +
    'dfaf59426abcdf0493c13d2f1d1b46b824a6ac1894b3d925250c181e3472c16078056e' +
    'b19a8d28f71f308092753481d49444fdf78c9ea6c24407dc018e77d3afef385b2ff743' +
    '9e96237941332dd446cebeffdb4404fe4f71595161d016402c334d0f57c61abe4ff9f4' +
    'cbf90281810087d87708d46763e4ccbeb2d1e9712e5bf0216d70de9420a5b2069b7459' +
    'b99f5d9f7f2fad7cd79aaee67a7f9a34437e3c79a84af0cd8de9dff268eb0c4793f501' +
    'f988d540f6d3475c2079b8227a23d968dec4e3c66503187193459630472bfdb6ba1de7' +
    '86c797fa6f4ea65a2a8419262f29678856cb73c9bd4bc89b5e041b2277', 'hex');

  const spki = Buffer.from(
    '30820122300d06092a864886f70d01010105000382010f003082010a0282010100d357' +
    '6092e62957364544e7e4233b7bdb293db2085122c479328546f9f0f712f657c4b17868' +
    'c930908cc594f7ed00c01442c1af04c2f678a48ba2c80fd1713e30b5ac50787ac35165' +
    '89f171967f6386ada34900a6bb04eecea42bf043ced9a0f94d0cc09e919b9d7166c08a' +
    'b6ce204640aea4c4920db6d86eb916d0dcc0f4341a10380429e7e1032144ea949de8f6' +
    'c0ccbf95fa8e928d70d8a38ce168db45f6f134663d6f656f5ceabc725da8c02aabeaaa' +
    '13ac36a75cc0bae135df3114b66589c7ed3cb61559ae5a384f162bfa80dbe4617f86c3' +
    'f1d010c94fe2c9bf019a6e63b3efc028d43cee611c85ec263c906c463772c6911b19ee' +
    'c096ca76ec5e31e1e30203010001', 'hex');

  // plaintext
  const plaintext = Buffer.from(
    '5f4dba4f320c0ce876725afce5fbd25bf83e5a7125a08cafe73c3ebac421779df9d55d' +
    '180c3ae9942645e1d82fee8c9d294b3cb1a08a9931201b3c0e81fc47cacf8315a2af66' +
    '324113c3b66230c34608c4f4593634ce02b267362277f0a840ca74bc3d1a6236952c5e' +
    'd7aaf8a8fecbddfa7584e6978cea5d2a5b9fb7f1b48c8b0be58a305202754d83761073' +
    '74793cf026aaee5300727d836cd71e71b345ddb2e44446ffc5b901635413890d910ea3' +
    '80984a90191031323f16dbcc9d6be168b84885384ca03e12600ac1c248028af3726cc9' +
    '3463882ea8c02aab', 'hex');

  // For verification tests.
  const signatures = {
    'sha-1': Buffer.from(
      '532e2f1b69cc2ee8472ef28f7f36a81a24cde4ee83858a7d17054ac3602c98dd432' +
      'e3b3690440935072bb7c031e680701d19b97cb5510d86c9bedbe7d1c06839ceed8a' +
      '3b6ac9564131c4512bbbabde237b4daa29fa0d3c97487b48a8fee9d63b50569dc6b' +
      '7d10850c8320559343b8537b61214a7e4543a714d65e21c4e478294eb4246cea668' +
      'e351fce0b4e118c758be4fdc46c7b3226bbf40b5b3950d62b8bdaa4f6bb76a30222' +
      'ba32734ed5df4ac8d4fffa7557105087a6acfba5b48516163bb916864e82cb861eb' +
      '910dcf6f1adbad5399afd497fb7afb7f75da83c80592ea1ade3e3803b4bb6831b93' +
      '3297c0fccc36937e46018797fca85947d29c6a27a81', 'hex'),
    'sha-256': Buffer.from(
      '13306aba251dee526459c28352a429cdd85554c7e4a6790a2c6e44b45ebbc4a00a0' +
      'a55244d62a60ddf0ed7d42d7714f12f783ac6709d0e2702db2692aeaacc5a5cdbbe' +
      'c173198caab0d14fe885d0a8da1f166a965c9e25d48470b4884d5c92a4d84417440' +
      '5568f4ac0340df6c410fc44cf7ee6d59ba634f9c6240c96b59a06fceeff4dd29622' +
      'e7f983aebf00ecf241f1c912cfd5dc6eeeb94f9d916113e843a98555c24257f8c3e' +
      'dab1f27839f8cc9a963e8b85465a56ec1d876225ae001fbd4244701e2e47d81b557' +
      '847e3827e33b36f3f5e8fedfa49a0d34d01dbdaf84fa5c752f0202a8cab2c4cc2cb' +
      '5076f6537d9c22d353738e9b39c97026b059ce95d89', 'hex'),
    'sha-384': Buffer.from(
      '354fcd1c62e2362d4e8bcedf5150f7b27bec33ab32a27975345a4c8cfeb234669bc' +
      '4abaf81e719ddf4c1afae45432cb7aeb9133cbd878de766e872628178a33ac20a02' +
      '8a7d8c2b641a5c523b16bbe65eb20bab331c983a961bae6de64e6b9077aa89c846b' +
      '8d69dcf7101478d10751a3b87b2a5de2ca6ce71a0bfed7f587a216e053a1e53c4a2' +
      'ace93c261b440fecd4330dd7cbd792b8398502b2a20845a4c2918d872aacf50b302' +
      '71357019a58ae18819e75c48e9ef80810860fa04964776ca04b200329674dca5320' +
      'b400f517864e71e087b68b81df613ee24bac34dcf2e64595e12c799070f3f719d93' +
      'd7843b69592346cfc20c6bbf93107f279d6207ec657', 'hex'),
    'sha-512': Buffer.from(
      '6229b70897f8620b635487cd4aa996269831ff2931d28714f01e58b165f1082c319' +
      '8b8f451788cfd3ed59a78f834d11ce285d1051c42a5cea0227fdefe293444c2518e' +
      'be5cb0055bea4b5806f0eba1b665022a63be44c088fe9ad26325d79f7c41ed97f90' +
      '9cd4ca28328e4c4a9de8da67c35dc1c85b71ed6ffaaf99d74b2b88e9f5f05a732f6' +
      '688c993b58a0ed35e8f0a106d4e8b1b360e334415c742e94675823db0fd25e22cff' +
      '7a6335c70e193235dcda48add6858626bd96311e60f7e5ea4491b6c1e6248afe12b' +
      'bbd54f8869b043a5b0444562813f0a98b300356f306e6b783a29f3bec97ca40ea20' +
      '062cab8926ec5d96aa387cc84821a6d72b8ea126e7d', 'hex')
  }

  const vectors = [
    {
      publicKeyBuffer: spki,
      privateKeyBuffer: pkcs8,
      algorithm: { name: 'RSASSA-PKCS1-v1_5' },
      hash: 'SHA-1',
      plaintext,
      signature: signatures['sha-1']
    },
    {
      publicKeyBuffer: spki,
      privateKeyBuffer: pkcs8,
      algorithm: { name: 'RSASSA-PKCS1-v1_5' },
      hash: 'SHA-256',
      plaintext,
      signature: signatures['sha-256']
    },
    {
      publicKeyBuffer: spki,
      privateKeyBuffer: pkcs8,
      algorithm: { name: 'RSASSA-PKCS1-v1_5' },
      hash: 'SHA-384',
      plaintext,
      signature: signatures['sha-384']
    },
    {
      publicKeyBuffer: spki,
      privateKeyBuffer: pkcs8,
      algorithm: { name: 'RSASSA-PKCS1-v1_5' },
      hash: 'SHA-512',
      plaintext,
      signature: signatures['sha-512']
    }
  ];

  return vectors;
}
