## Usage

```js
const Token = require('{%= name %}');
```

## API
{%= apidocs("index.js") %}

## Release history

See [the changelog](CHANGELOG.md).

## Token objects

Lexer tokens are represented as `Token` objects that implement the following interface:

```js
interface Token {
  type: string;
  value: string;
  match: array | undefined;
}
```

### Token properties

- `type` **{string}** - A string representing the token variant type. This property is necessary for classifying one or more characters so that parsers or compilers can determine what to do with the token.
- `value` **{string}** - The substring (or [lexeme]()) that was captured for the token.
- `match` **{array|undefined}** - If a regular expression was used to capture a substring, the `RegExp.exec()` or `String.match()` arguments array can be stored on the token. 

**Source location**

Add the source location (start, end, index and range) information to tokens using either of the following plugins (depending on preference for property naming conventions):

- [snapdragon-position][]
- [snapdragon-location][]
