/* $Id: Rna_feat_type.cpp 436427 2014-05-28 13:24:42Z chenj $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  J. Chen
 *
 * File Description:
 *   DoesFeatureMatchRnaType
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using the following specifications:
 *   'macro.asn'.
 */

// standard includes
#include <ncbi_pch.hpp>

// generated includes
#include <objects/macro/Rna_feat_type.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

// destructor
CRna_feat_type::~CRna_feat_type(void)
{
}

struct s_rnafeattype2rnareftype {
    CRna_feat_type :: E_Choice rna_feat_type;
    CRNA_ref::EType rna_ref_type;
}RnaFeatType2RnaRefType;

static const s_rnafeattype2rnareftype rna_tp_map[] = {
 { CRna_feat_type::e_PreRNA , CRNA_ref::eType_premsg} ,
 { CRna_feat_type::e_MRNA , CRNA_ref::eType_mRNA} ,
 { CRna_feat_type::e_TRNA , CRNA_ref::eType_tRNA} ,
 { CRna_feat_type::e_RRNA , CRNA_ref::eType_rRNA} ,
 { CRna_feat_type::e_NcRNA , CRNA_ref::eType_ncRNA} ,
 { CRna_feat_type::e_TmRNA , CRNA_ref::eType_tmRNA} ,
 { CRna_feat_type::e_MiscRNA , CRNA_ref::eType_miscRNA} 
};

CRNA_ref :: EType CRna_feat_type :: GetRnaRefType(E_Choice choice) const
{
   for (unsigned i=0; i< ArraySize(rna_tp_map); i++) {
      if (rna_tp_map[i].rna_feat_type == choice) {
        return rna_tp_map[i].rna_ref_type;
      }
   }
   return CRNA_ref :: eType_unknown;
};

bool CRna_feat_type :: Match(const CSeq_feat& feat) const
{
   if (IsAny()) {
      return true;
   }
   if (!feat.GetData().IsRna()) {
      return false;
   }
   const CRNA_ref& rna_ref = feat.GetData().GetRna();

   CRNA_ref::EType ref_type4feat_type = GetRnaRefType(Which());
   if (rna_ref.GetType() ==  ref_type4feat_type) {
      if (IsNcRNA()) {
         if (GetNcRNA().empty()) {
            return true;
         }
         else if (rna_ref.CanGetExt() 
                     && rna_ref.GetExt().IsGen()
                     && rna_ref.GetExt().GetGen().CanGetClass()
                     && rna_ref.GetExt().GetGen().GetClass() 
                            == GetNcRNA()) {
            return true;
        }
        else {
           return false;
        }
      }
      else {
         return true;
      }
   } 
   return false;
};

END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 57, chars: 1732, CRC32: 45d347bf */
