/*
 * Decompiled with CFR 0.152.
 */
package org.lisaac.ldt.outline;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.lisaac.ldt.editors.ColorManager;
import org.lisaac.ldt.model.items.Prototype;
import org.lisaac.ldt.outline.OutlineImages;
import org.lisaac.ldt.outline.OutlineItem;
import org.lisaac.ldt.outline.OutlineSection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutlinePrototype
extends OutlineItem {
    protected String name;
    protected List<OutlineItem> sections;

    public OutlinePrototype(Prototype prototype, List<OutlineItem> sections) {
        this.name = prototype.getName();
        this.sections = sections;
    }

    @Override
    public String getText() {
        return this.name;
    }

    @Override
    public StyledString getStyledText() {
        ColorManager colors = ColorManager.getDefault();
        return new StyledString(this.name, colors.getPrototypeStyler());
    }

    public String toString() {
        return this.name;
    }

    @Override
    public Image getImage() {
        return OutlineImages.PROTOTYPE;
    }

    @Override
    public List<OutlineItem> getChildren() {
        List<OutlineItem> result;
        if (showSections) {
            result = this.sections;
        } else {
            result = new ArrayList<OutlineItem>();
            int i = 0;
            while (i < this.sections.size()) {
                result.addAll(((OutlineSection)this.sections.get((int)i)).slots);
                ++i;
            }
        }
        return result;
    }

    @Override
    public int compareTo(Object arg0) {
        return 0;
    }
}

