package org.mozilla.jss.netscape.security.util;

import java.nio.charset.Charset;
import java.nio.charset.spi.CharsetProvider;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ASN1CharsetProvider extends CharsetProvider {

    protected Map<String, Charset> charsets = new HashMap<>();

    public ASN1CharsetProvider() {
        addCharset(new PrintableCharset());
        addCharset(new IA5Charset());
        addCharset(new UniversalCharset());
    }

    @Override
    public Iterator<Charset> charsets() {
        return charsets.values().iterator();
    }

    @Override
    public Charset charsetForName(String charsetName) {
        return charsets.get(charsetName);
    }

    public void addCharset(Charset cs) {
        charsets.put(cs.name(), cs);
    }
}
