/*
 ----------------------------------------------------------------------------
 |    Copyright (C) 1999   Raytheon Systems Company                         |
 ----------------------------------------------------------------------------
 */

#include     <HE5_HdfEosDef.h>

/*
 * In this example we will open an HDF-EOS file and attach to
 * a ZA structures within the file to write a dimension scales
 */


int main()
{
  herr_t          status = FAIL;

  hid_t           zafid = FAIL;
  hid_t           zaid1 = FAIL;

  int             data[15]={1,2,3,6,9,12,15,18,23,26,29,32, 33,34,35};
  char            label[16];
  char            unit[16];
  char            format[16];
  int             nbands;
  hsize_t         count[3];

  /*
   * We first open the HDF-EOS ZA file, "Za.h5".  Because this file
   * already exist and we wish to write to it, we use the H5F_ACC_RDWR access
   * code in the open statement.  The HE5_ZAopen routine returns the ZA file
   * id, zafid, which is used to identify the file in subsequent routines.
   */ 

  zafid = HE5_ZAopen("ZA.he5", H5F_ACC_RDWR);
 
  /*
   * If the ZA file cannot be found, HE5_ZAopen will return -1 for the file
   * handle (zafid).  We there check that this is not the case before
   * proceeding with the other routines.
   * 
   * The HE5_ZAattach routine returns the handle to the existing ZA "Za1",
   * zaid1.  If the ZA is not found, HE5_ZAattach returns -1 for the handle.
   */ 

  if (zafid != FAIL)
    {	  
      zaid1 = HE5_ZAattach(zafid, "ZA1");

      /* the field Spectra has Time,YDim,XDim dimensions. 
	 Bands dim is set to 15
      */

      if (zaid1 == -1)
	{
	  printf("\t\tError: Cannot attach to ZA \"ZA1\"\n");
	  HE5_ZAclose(zafid);
	  return -1;
	}
      
      nbands = 15;
      
      status = HE5_ZAdefdimscale2(zaid1, "Bands", "bandds", nbands, H5T_NATIVE_INT, (void *)data);
      if (status == -1)
	{
	  printf("\t\tError: Cannot def Dimension Scale for Bands dimemnsion in ZA fields \n");
	  HE5_ZAdetach(zaid1);
	  HE5_ZAclose(zafid);
	  return -1;
	}
      
      strcpy(label, "Bands Dim");
      strcpy(unit, "None");
      strcpy(format, "I2");
      
      count[0]= 12;
      status = HE5_ZAwritedscaleattr(zaid1, "Bands", "label", H5T_NATIVE_CHAR, count, label);
      if (status == -1)
	{
	  printf("\t\tError: Cannot def Dimension Scale strs for Bands dimemnsion in ZA fields \n");
	  HE5_ZAdetach(zaid1);
	  HE5_ZAclose(zafid);
	  return -1;
	}

      count[0]= 6;
      status = HE5_ZAwritedscaleattr(zaid1, "Bands", "unit", H5T_NATIVE_CHAR, count, unit);
      if (status == -1)
	{
	  printf("\t\tError: Cannot def Dimension Scale strs for Bands dimemnsion in ZA fields \n");
	  HE5_ZAdetach(zaid1);
	  HE5_ZAclose(zafid);
	  return -1;
	}
      
      count[0]= 4;
      status = HE5_ZAwritedscaleattr(zaid1, "Bands", "format", H5T_NATIVE_CHAR, count, format);
      if (status == -1)
	{
	  printf("\t\tError: Cannot def Dimension Scale strs for Bands dimemnsion in ZA fields \n");
	  HE5_ZAdetach(zaid1);
	  HE5_ZAclose(zafid);
	  return -1;
	}
         
      int datbuf_i1[1] = {-999};
      count[0]= 1;
      status = HE5_ZAwritedscaleattr(zaid1, "Bands", "MissingValue", H5T_NATIVE_INT, count, datbuf_i1);
      if (status == -1)
	{
	  printf("\t\tError: Cannot def Dimension Scale strs for Bands dimemnsion in ZA fields \n");
	  HE5_ZAdetach(zaid1);
	  HE5_ZAclose(zafid);
	  return -1;
	}
      
      int datbuf_i2[3] = {-999,0,999};
      count[0]= 3;
      status = HE5_ZAwritedscaleattr(zaid1, "Bands", "IntValues", H5T_NATIVE_INT, count, datbuf_i2);
      if (status == -1)
	{
	  printf("\t\tError: Cannot def Dimension Scale strs for Bands dimemnsion in ZA fields \n");
	  HE5_ZAdetach(zaid1);
	  HE5_ZAclose(zafid);
	  return -1;
	}
      
      HE5_ZAdetach(zaid1);
      
      HE5_ZAclose(zafid);
      
      return 0;
    }
}
