/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.ast.ASTInitializer;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.ASTMethodDeclarator;
import net.sourceforge.pmd.ast.AccessNode;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.symboltable.ClassScope;
import net.sourceforge.pmd.symboltable.MethodNameDeclaration;
import net.sourceforge.pmd.symboltable.NameOccurrence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnusedPrivateMethodRule
extends AbstractRule {
    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isInterface()) {
            return data;
        }
        Map<MethodNameDeclaration, List<NameOccurrence>> methods = ((ClassScope)node.getScope()).getMethodDeclarations();
        for (MethodNameDeclaration mnd : this.findUnique(methods)) {
            List<NameOccurrence> occs = methods.get(mnd);
            if (!this.privateAndNotExcluded(mnd)) continue;
            if (occs.isEmpty()) {
                this.addViolation(data, mnd.getNode(), mnd.getImage() + mnd.getParameterDisplaySignature());
                continue;
            }
            if (!this.calledFromOutsideItself(occs, mnd)) continue;
            this.addViolation(data, mnd.getNode(), mnd.getImage() + mnd.getParameterDisplaySignature());
        }
        return data;
    }

    private Set<MethodNameDeclaration> findUnique(Map<MethodNameDeclaration, List<NameOccurrence>> methods) {
        HashSet<MethodNameDeclaration> unique = new HashSet<MethodNameDeclaration>();
        HashSet<String> sigs = new HashSet<String>();
        for (MethodNameDeclaration mnd : methods.keySet()) {
            String sig = mnd.getImage() + mnd.getParameterCount() + mnd.isVarargs();
            if (!sigs.contains(sig)) {
                unique.add(mnd);
            }
            sigs.add(sig);
        }
        return unique;
    }

    private boolean calledFromOutsideItself(List<NameOccurrence> occs, MethodNameDeclaration mnd) {
        int callsFromOutsideMethod = 0;
        for (NameOccurrence occ : occs) {
            SimpleNode occNode = occ.getLocation();
            ASTConstructorDeclaration enclosingConstructor = occNode.getFirstParentOfType(ASTConstructorDeclaration.class);
            if (enclosingConstructor != null) {
                ++callsFromOutsideMethod;
                break;
            }
            ASTInitializer enclosingInitializer = occNode.getFirstParentOfType(ASTInitializer.class);
            if (enclosingInitializer != null) {
                ++callsFromOutsideMethod;
                break;
            }
            ASTMethodDeclaration enclosingMethod = occNode.getFirstParentOfType(ASTMethodDeclaration.class);
            if (enclosingMethod != null && mnd.getNode().jjtGetParent().equals(enclosingMethod)) continue;
            ++callsFromOutsideMethod;
        }
        return callsFromOutsideMethod == 0;
    }

    private boolean privateAndNotExcluded(MethodNameDeclaration mnd) {
        ASTMethodDeclarator node = (ASTMethodDeclarator)mnd.getNode();
        return ((AccessNode)node.jjtGetParent()).isPrivate() && !node.hasImageEqualTo("readObject") && !node.hasImageEqualTo("writeObject") && !node.hasImageEqualTo("readResolve") && !node.hasImageEqualTo("writeReplace");
    }
}

