#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.

from fenrirscreenreader.core.i18n import _
from fenrirscreenreader.utils import line_utils


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return _("current line")

    def run(self):
        x, y, last_line = line_utils.get_current_line(
            0,
            self.env["screen"]["lines"] - 1,
            self.env["screen"]["new_content_text"],
        )

        if last_line.isspace():
            self.env["runtime"]["OutputManager"].present_text(
                _("blank"), sound_icon="EmptyLine", interrupt=True
            )
        else:
            self.env["runtime"]["OutputManager"].present_text(
                last_line, interrupt=True
            )

    def set_callback(self, callback):
        pass
