/* Ejemplo usando tcpsock dll
Una vez se hayan conectados todos los clientes al servidor, ste les enviar a todos n aleatorios hasta la finalizacin del mismo.
Los clientes vern el ltimo n aleatorio recibido, cuantos mensajes han recibido del servidor y el ping en relacin al ltimo mensaje recibido.
*/
PROGRAM tcpsock;
import "tcpsock.dll";
const clients=2; // numero de clientes a conectar
global option;
begin

	full_screen=false;
	tcpsock_init(); // Inicializamos la librera tcpsock
	write(0,5,5,0,"1. Servidor");
	write(0,5,15,0,"2. Cliente");
	write(0,5,25,0,"3. Salir");
	write(0,5,75,0,"Host: "+tcpsock_get_iphost(0)); // Mostramos Host de la mquina
	write(0,5,85,0,"IP: "+tcpsock_get_iphost(1)); // Mostramos IP de la mquina

	while (option==0)
	if (key(_1)) option=1;server();end
	if (key(_2)) option=1;client();end
	if (key(_3)) option=1;tcpsock_quit();end; // Cerramos la librera tcpsock
	frame;
	end;
end;

process server()
private
int socket_listen, socket[clients-1];// socket_listen para recoger peticiones, socket[clients-1] para manejar peticiones
int data;
int connection=0;
int i;
int informacion; // enviaremos a los clientes nmeros aleatorios entre 0 y 32768
int ipaddr;
begin
delete_text(0);
socket_listen=tcpsock_open(); // nuevo socket
tcpsock_bind(socket_listen,1200); // asociamos socket_listen con el puerto 1200
tcpsock_listen(socket_listen,clients); // numero de conexiones a escuchar igual a clients
	write(0,5,5,0,"Esperando conexion de cliente(s)...");
	frame;
	while (connection<clients) // Mientras no hayan conectado los clientes esperamos su conexin


		if ((socket[connection]=tcpsock_accept(socket_listen,&ipaddr))!=-1) // Si recibimos una peticin de conexin distinta de -1, la aceptamos
		connection++;data++;
		tcpsock_send(socket[connection-1],&data,len(data)); // Enva el nmero de jugador al nuevo cliente
		end;

		if (key(_esc)) // Cerramos el programa aunque no hayan conectado todos los clientes
		tcpsock_close(socket_listen); // Cierra el socket
		for (i=0;i<clients;i++)
		tcpsock_close(socket[connection]);// Cierra el socket
		end;
		exit(0,0);
		tcpsock_quit(); // Cerramos la librera tcpsock
		end

	frame;
	end;

	delete_text(0);
	write(0,5,5,0,"Todos los clientes han conectado");
	write(0,5,25,0,"Enviando mensajes a todos ellos...");

loop
	for (i=0;i<connection;i++) // N aleatorio que enviamos a cada cliente
	informacion=rand(0,32768);
	tcpsock_send(socket[i],&informacion,len(informacion));
	end;

if (key(_esc))
	tcpsock_close(socket_listen); // Cierra el socket
	for (i=0;i<clients;i++)
	tcpsock_close(socket[connection]);// Cierra el socket
	end;
	exit(0,0);
	tcpsock_quit(); // Cerramos la librera tcpsock
end

frame;
end;
end;

process client()
private
int socket;
int data;
int informacion=1; // recibe la informacin (n aleatorio 0-32768) que enva en cada mensaje el servidor
int envios; // n de mensajes recibidos desde la conexin
int ping[1];
begin
delete_text(0);
socket=tcpsock_open();// nuevo socket
write(0,5,5,0,"Conectando...");
tcpsock_socketset_free(0);// iniciamos el socketset 0
tcpsock_socketset_add(0,socket);// aadimos el socket al socketset 0
frame;

	if (tcpsock_connect(socket,"127.0.0.1",1200)==0) // Conectamos al servidor con ip 127.0.0.1 y puerto 1200
	delete_text(0);
	write(0,5,5,0,"Conectado");
	frame;

		if (tcpsock_socketset_check(0)>0) // si hay actividad en el socket recibimos el n de jugador
		tcpsock_recv(socket,&data,sizeof(data)); // Recibimos el nmero de jugador
		write(0,135,35,0,data);
		end;
		write(0,5,35,0,"Soy el jugador: ");
		write(0,5,70,0,"Mensajes recibidos del servidor: ");
		write(0,5,105,0,"Ping:            ms");
		write(0,5,140,0,"Ultimo n aleatorio recibido: ");
		write_int(0,250,70,0,offset(envios));
		write_int(0,60,105,0,offset(ping[0]));
		write_int(0,250,140,0,offset(informacion));
	else
	delete_text(0);
	write(0,5,5,0,"No se pudo conectar");
	end;

loop
	if (tcpsock_socketset_check(0)>0) // si hay actividad en el socket recibimos el mensaje
		if (tcpsock_recv(socket,&informacion,sizeof(informacion))>0); // Recibimos mensaje (n aleatorio en informacin)
		envios++; // nuevo mensaje recibido
		ping[1]=timer[0]; // ha llegado un mensaje, hay transmisin fluida
		end;
	end;

if (timer[1]>100) ping[0]=timer[0]-ping[1];timer[1]=0;end // refrescamos el ping

// Se puls escape y cierra el programa
if (key(_esc)) tcpsock_socketset_free(0);tcpsock_close(socket);tcpsock_quit();exit(0,0);end // Cierra el socket y cerramos librera tcpsock
frame;
end;
end;
