#!/bin/sh
# (C) Copyright 2005- ECMWF.
#
# This software is licensed under the terms of the Apache Licence Version 2.0
# which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
# 
# In applying this licence, ECMWF does not waive the privileges and immunities granted to it by
# virtue of its status as an intergovernmental organisation nor does it submit to any jurisdiction.
#

. ./include.ctest.sh


# Define a common label for all the tmp files
label="bufr_attributes_test_f"

# Define tmp file
fTmp=${label}.tmp.txt
rm -f ${fTmp}

# We check "syno_multi.bufr". The path is hard coded in the example
${examples_dir}/eccodes_f_bufr_attributes > $fTmp

# Check the results
grep -q 'airTemperatureAt2M->percentConfidence->code: *33007' $fTmp
grep -q 'airTemperatureAt2M->percentConfidence->width: *7'    $fTmp

rm -f ${fTmp}
