
proc query {args} {
    set q [concat adns synch $args]
    puts "% $q"
    set r [eval $q]
    puts "=> $r"
    return $r
}
proc query_ok {args} {
    set r [eval query $args]
    set outcome [lindex $r 0]
    if {"$outcome" != "ok"} { error "outcome $outcome, not ok" }
    return [lindex $r 6]
}

# We could perhaps do this with a mocked nameserver but that seems
# like an excessive effort.
#
# Use mythic-beasts as a test case.
# They are very likely to have both A and AAAA RRsets for the foreseeable.

query_ok a www.mythic-beasts.com
query_ok aaaa www.mythic-beasts.com

set data [query_ok addr www.mythic-beasts.com]

set got_type(INET) 0
set got_type(INET6) 0
foreach addr $data {
    incr got_type([lindex $addr 0])
}
foreach type [array names got_type] {
    if {$got_type($type) == 0} { error $r "no $type" }
}
