package charactermanaj.model;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.net.URI;
import java.util.Map;
import java.util.logging.Logger;

import charactermanaj.ui.model.WallpaperInfo;

public class WorkingSet {

	/**
	 * ロガー
	 */
	private static final Logger logger = Logger.getLogger(WorkingSet.class.getName());

	private Map<PartsIdentifier, PartsColorInfo> partsColorInfoMap;

	private String characterDataRev;

	/**
	 * 現在の選択中のパーツと色設定からのパーツセット
	 */
	private PartsSet currentPartsSet;

	private URI characterDocBase;

	private File lastUsedSaveDir;

	private File lastUsedExportDir;

	// ver0.92
	private PartsSet lastUsePresetParts;

	// ver0.94
	private CharacterData characterData;

	// ver0.97
	private WallpaperInfo wallpaperInfo;

	// ver0.999

	/**
	 * ズーム
	 */
	private Double zoomFactor;

	/**
	 * ビューの中央位置
	 * (ズーム倍率の保存はv0.999から、未指定の場合はnull)
	 */
	private Point viewPosition;

	/**
	 * ウィンドウの位置と大きさ
	 */
	private Rectangle windowRect;

	/**
	 * データのダウンロードが不要である
	 */
	private boolean noNeedDataDownload;

	public void setCharacterDataRev(String characterDataRev) {
		this.characterDataRev = characterDataRev;
	}

	/**
	 * REV情報.<br>
	 * キャラクターデータが設定されていない場合に使用される.<br>
	 * (ver0.96以前旧シリアライズデータ互換用)<br>
	 *
	 * @return
	 */
	public String getCharacterDataRev() {
		return characterDataRev;
	}

	public Map<PartsIdentifier, PartsColorInfo> getPartsColorInfoMap() {
		return partsColorInfoMap;
	}

	public void setPartsColorInfoMap(
			Map<PartsIdentifier, PartsColorInfo> partsColorInfoMap) {
		this.partsColorInfoMap = partsColorInfoMap;
	}

	public void setCharacterDocBase(URI characterDocBase) {
		this.characterDocBase = characterDocBase;
	}

	public void setCurrentPartsSet(PartsSet currentPartsSet) {
		this.currentPartsSet = currentPartsSet;
	}

	public URI getCharacterDocBase() {
		return characterDocBase;
	}

	public PartsSet getCurrentPartsSet() {
		return currentPartsSet;
	}

	public void setLastUsedSaveDir(File lastUsedSaveDir) {
		this.lastUsedSaveDir = lastUsedSaveDir;
	}

	public void setLastUsedExportDir(File lastUsedExportDir) {
		this.lastUsedExportDir = lastUsedExportDir;
	}

	public File getLastUsedSaveDir() {
		return lastUsedSaveDir;
	}

	public File getLastUsedExportDir() {
		return lastUsedExportDir;
	}

	/**
	 * 最後に使用したお気に入りの情報.<br>
	 * 一度もプリセットを使ってなければnull.<br>
	 * ver0.94以前には存在しなかったため、nullになりえます。
	 *
	 * @return
	 */
	public PartsSet getLastUsePresetParts() {
		return lastUsePresetParts;
	}

	/**
	 * /** 最後に使用したお気に入りの情報.<br>
	 * 一度もプリセットを使ってなければnull.<br>
	 * (ver0.94以前には存在しなかったため、nullになりえます。)
	 *
	 * @param lastUsePresetParts
	 */
	public void setLastUsePresetParts(PartsSet lastUsePresetParts) {
		this.lastUsePresetParts = lastUsePresetParts;
	}

	public void setCharacterData(CharacterData characterData) {
		this.characterData = characterData;
	}

	/**
	 * 使用していたキャラクター定義を取得します.<br>
	 * ver0.95よりも以前には存在しないため、nullとなりえます.<br>
	 *
	 * @return キャラクターデータ
	 */
	public CharacterData getCharacterData() {
		return characterData;
	}

	/**
	 * 壁紙情報を取得します.<br>
	 * ver0.97よりも以前には存在しないため、nullとなりえます.<br>
	 *
	 * @return 壁紙情報
	 */
	public WallpaperInfo getWallpaperInfo() {
		return wallpaperInfo;
	}

	public void setWallpaperInfo(WallpaperInfo wallpaperInfo) {
		this.wallpaperInfo = wallpaperInfo;
	}

	/**
	 * ビューの左上位置
	 * @return
	 */
	public Point getViewPosition() {
		return viewPosition;
	}

	public void setViewPosition(Point viewPosition) {
		this.viewPosition = viewPosition;
	}

	/**
	 * ズーム
	 * @return
	 */
	public Double getZoomFactor() {
		return zoomFactor;
	}

	public void setZoomFactor(Double zoomFactor) {
		this.zoomFactor = zoomFactor;
	}

	/**
	 * ウィンドウサイズ
	 * @return
	 */
	public Rectangle getWindowRect() {
		return windowRect;
	}

	public void setWindowRect(Rectangle windowRect) {
		this.windowRect = windowRect;
	}

	public boolean isNoNeedDataDownload() {
		return noNeedDataDownload;
	}

	public void setNoNeedDataDownload(boolean noNeedDataDownload) {
		this.noNeedDataDownload = noNeedDataDownload;
	}

	@Override
	public String toString() {
		return "docBase:" + characterDocBase + "/rev:" + characterDataRev;
	}
}
