if(NOT CFITSIO_FOUND)

    find_path(CFITSIO_INCLUDE_DIR fitsio.h
        HINTS $ENV{CFITSIO_ROOT_DIR} 
        PATH_SUFFIXES include include/cfitsio)
    find_library(CFITSIO_LIBRARY cfitsio
        HINTS $ENV{CFITSIO_ROOT_DIR} 
        PATH_SUFFIXES lib)
  
    include(FindPackageHandleStandardArgs)
    find_package_handle_standard_args(CFITSIO DEFAULT_MSG
        CFITSIO_LIBRARY CFITSIO_INCLUDE_DIR)

endif(NOT CFITSIO_FOUND)

if (CFITSIO_FOUND) 
  set(CFITSIO_INCLUDE_DIRS ${CFITSIO_INCLUDE_DIR})
  set(CFITSIO_LIBRARIES ${CFITSIO_LIBRARY})

  if(NOT TARGET CFITSIO::CFITSIO)
    add_library(CFITSIO::CFITSIO UNKNOWN IMPORTED)
    set_target_properties(CFITSIO::CFITSIO PROPERTIES
      IMPORTED_LINK_INTERFACE_LANGUAGES "C"
      IMPORTED_LOCATION "${CFITSIO_LIBRARY}"
      INTERFACE_INCLUDE_DIRECTORIES "${CFITSIO_INCLUDE_DIRS}")
  endif()
endif()

mark_as_advanced(CFITSIO_INCLUDE_DIR CFITSIO_LIBRARY)
