/**
 * WAV file reader.
 * @file
 * @author Umberto Salsi <salsi@icosaedro.it>
 * @version $Date: 2017/09/05 21:57:02 $
 */

#ifndef WAV_H
#define WAV_H

#include <stdint.h>

#ifdef wav_IMPORT
	#define EXTERN
#else
	#define EXTERN extern
#endif

typedef struct {
	/** Copy of the file name from which the WAV has been read. */
	char *filename;
	/** WAV format tag, normally 1 (PCM). */
	uint16_t wFormatTag;
	/** Number of channels (one or more). */
	uint16_t nChannels;
	/** Number of samples per seconds. */
	uint32_t nSamplesPerSec;
	/** ? */
	uint32_t nAvgBytesPerSec;
	/** Block size for each sample (bytes). */
	uint16_t nBlockAlign;
	/** Number of bits per sample. Its value is less or equal to 8*nBlockAlign. */
	uint16_t wBitsPerSample;
	/** Frame length in bytes. Its value is exactly nChannels times nBlockAlign.
	 * Each frame contains a sample for each channel, in the order. */
	uint32_t frameLength;
	/** Length of the sampled data (bytes). It is a multiple of the frame length. */
	uint32_t data_len;
	/** Samples data. The byte ordering of the samples is little-endian. */
	char *data;
} wav_Type;

/**
 * Reads WAV file. Any error accessing the file is fatal. Any inconsistency in
 * the file contents is fatal.
 * @return WAV contents. Must be released with memory_dispose().
 */
EXTERN wav_Type * wav_fromFile(char *filename);

#undef EXTERN
#endif
